stochastic variables to realize their values. Alternatively, we can show how expensive it is to fix to a solution now that ignores future changes.

Consider a payoff table based on m possible decisions Difor i = 1, ..., m and n **possible scenarios**
Sj for j = 1, ..., n. The payoff for decision Di, if scenario Sj will occur, is aij **. Suppose the probability**
that scenario Sj will occur is pj **. If the decision criterion is the expected payoff, then the best decision**
is the one that maximizes Pn j=1 pjaij **and the solution is called "stochastic solution", SS.**
There is a family of models, one for each scenario, and the weighted average of solutions for each scenario (solved by assuming that all data were already known) gives the expected "wait-and-see solution", WSS.

Consider the hypothetical situation that one knows ahead of **time which scenario will occur. If such**
information is available then one may expect extra payoff with a non-negative value. The expected value of payoff can serve as an upper bound for the value of information, which is called the "expected value of perfect nformation" (EVPI). It is assumed that the probability that the perfect information will indicate that scenario Sj **will occur is also** pj .

From the definition, the EVPI is the difference between the expected payoff calculated using the maximum aij **for each scenario (WSS) and the expected payoff for the best decision (SS).**
The expression for the EVPI is thus:

$$EVPI=WSS-SS=\sum_{j=1}^{n}p_{j}\operatorname*{max}_{1\leq i\leq m}\left\{a_{i j}\right\}-\operatorname*{max}_{1\leq i\leq m}\left\{\sum_{j=1}^{n}p_{j}a_{i j}\right\}$$

This is therefore the most that should be spent in gathering information about the uncertain world. For stochastic optimization problems, we may compute another statistics which quantify the importance of randomness. The "value of stochastic solution", VSS, measures the possible gain from solving the stochastic model that explicitly incorporates **the distribution of random variables within**
the problem formulation.

Some models do not take into account the randomness of different uncertain parameters. They replace the uncertain parameters by their expected values and solve then the so called expected value problem. It means that only one scenario, namely the expected value scenario, is considered. In this case the solution to the expected value scenario will give an **objective function value for the stochastic** problem, which is called the "expected value solution", EVS.

The value of a stochastic solution (VSS) is then the difference **between SS and EVS:**

## V Ss = Ss − **Ev S** ≥ 0.

This computes the benefit of knowing the distributions of the **stochastic variables. It is a well-known** fact in decision theory that the above relation is valid. This means that the objective function's expected value of the stochastic optimization problem will be better than the expected value of deterministic programming.

These statistics can easily be calculated using our framework. Such calculation requires the solution of n independent deterministic scenario problems to determine **WSS and a single expected value**
problem to determine EVS.