
## 7 Scenario Reduction

Each scenario introduces new decision variables. For many practical problems, it is too expensive to compute all possible scenarios. How then can we replace a large, computationally intractable scenario tree with a small, tractable tree so that solving the problem **over the small tree yields a solution not** much different than the solution over the large tree?

We have implemented several techniques to reduce the number of scenarios. These scenario reduction algorithms determine a subset of scenarios and a redistribution of probabilities relative to the preserved scenarios. No requirements on the stochastic data process are imposed and therefore the concept is general. However, the reduction algorithms, depending on their sophistication, may require different types of data.

The simplest scenario reduction algorithm is to consider just a single scenario in which stochastic variables take their expected values. This is supported with the command:

## Scenario Expected;

This is actually the aforementioned (see Sec.6) expected value problem. Among the other methods presented here, this is the most crude one.

The user may also be content to consider just a few of the most probable scenarios and ignore rare events. This method is referred as "mostlikely" in the rest of the paper. We support this with the command:

## Scenario Top <Num>;

Another option is to use Monte Carlo sampling. The user can specify the number of scenarios to sample using a command of the form:

## Scenario Sample <Num>;

The probability distributions of the stochastic variables **is used to bias the construction of these** scenarios.

We can also consider sampling methods which may converge faster than simple Monte Carlo sampling. For example, we implemented one of the best sampling methods from experimental design, and one of the best scenario reduction methods from operations research. Latin hypercube sampling (LHS) [17], ensures that a range of values for a variable are sampled. Suppose we want the sample size to be n. We divide the unit interval into n **intervals, and sample a value for each stochastic variable**
whose cumulative probability occurs in each of these interval. We then construct n **sample scenarios**
from these values, enforcing the condition that the samples **use each value for each stochastic variable**
exactly once. More precisely, let fi(a) be the cumulative probability that Xi takes the value a **or less,** Pi(j) be the jth element of a random permutation Pi of the integers {0, . . . , n−1}, and r **be a random**
number uniformly drawn from [0, 1]. Then, the j**th Latin hypercube sample value for the stochastic**
variable Xiis:
f
−1 i( Pi(j) + r n)
However, it should be noted that the sample size n **does not guarantee to produce a sample of** n scenarios, since a single scenario may be chosen more than once due to, for example, the discreteness of the data. The command for LHS is 13