
## Scenario Lhs <Num>;

where <Num> **denotes the number of non-overlapping intervals used with LHS.**
Finally, we implemented a scenario reduction method used in **stochastic programming due to**
Dupacova, Growe-Kuska and Romisch [4]. Dupacova et al. assume that the original probability measure P **is discrete with finitely many scenarios and this probability measure is approximated by a**
probability measure Q **of a smaller number of scenarios. In this case, the upper bound for the distance** between P and Q **is a Kantorovich functional. Then the upper bound represents the optimal value**
of a Monge-Kantorovich mass transportation problem. The Monge-Kantorovich mass transportation problem dates back to work by Monge in 1781 on how to optimally **move material from one place to** another, knowing only its initial and final spatial distributions, the cost being a prescribed function of the distance travelled by molecules of material [22], [23]. **Dupacova et al. show that the Kantorovich**
functional of the original probability distribution P and the optimal reduced measure Q **based on a** given subset of scenarios of P as well as the optimal weights of Q **can be computed without solving**
the Monge-Kantorovich problem. Their backward reduction algorithm for determining a subset of scenarios is given below.

Let nT denote the number of stages of the optimization problem and ns **the number of scenarios.**
A scenario ω
(i), i ∈ {1, ..., ns}**, is defined as a sequence of nodes of the tree**

$$\omega^{(i)}=(\eta_{0}^{(i)},\eta_{1}^{(i)},...,\eta_{n T}^{(i)}),\qquad i=1,...,n_{s}$$

For each node belong to scenario j on stage s**, a vector** p
(j)
s ∈ R
n p s **of parameters is given. The**
probability to get from η
(i)
jto η
(i)
j+1 **is denoted by** π
(i)
j,j+1**. Thus the probability for the whole scenario**
ω
(i)**is given by**

$$\pi^{(i)}=\prod_{j=0}^{n_{T}-1}\pi_{j,j+1}^{(i)}$$

The distance between two scenarios ω
(i) and ω
(j)**is defined as**

$$d(\omega^{(i)},\omega^{(j)})={\sqrt{\sum_{s=0}^{n_{T}}(\mathbf{p}_{s}^{(i)}-\mathbf{p}_{s}^{(j)})^{2}}}$$

according to the Euclidean norm in the space of the parameter **vectors.**
The scenario deletion procedure given below is applied iteratively, deleting one scenario in each iteration, until a given number of scenarios remains.

S1. Determine the scenario to be deleted: Remove scenario ω
(s
∗
), $s^*\in\{1\}$  . 
∗ ∈ {1, ..., ns} **satisfying**
$$\pi^{(s^{*})}\operatorname*{min}_{\bar{s}\neq s^{*}}d(\omega^{(\bar{s})},\omega^{(s^{*})})=\operatorname*{min}_{m,n\in\{1,\ldots,n_{s}\}}\left\{\pi^{(m)}\operatorname*{min}_{n\neq m}d(\omega^{(n)},\omega^{(m)})\right\}$$

Hence, not only the distances, but also the probabilities of **the scenarios are considered.**
S2. Change the number of scenarios: ns := ns − 1.