
## 8.2 Agricultural Planning

Farmers must deal with uncertainty since weather and many other factors affect crop yields. In this example (also taken from [2]), we must decide on how many acres of his fields to devote to various crops before the planting season. A certain amount of each crop is required for cattle feed, which can be purchased from a wholesaler if not raised on the farm. Any crop in excess of cattle feed can be sold up to the EU quota; any amount in excess of this quota will be sold at a low price. Crop yields are uncertain, depending upon weather conditions during the growing season. This test problem
(Agricultural Planning - I) has 4 stages and 10,000 scenarios. The CP model has 55 decision variables and 30 constraints for one scenario, and 163,324 decision variables and 116,661 constraints for 10,000 scenarios. In Fig. 4, we again see that Dupacova et al's algorithm and Latin hypercube sampling are very effective, and both are far ahead of the most likely scenario method. Fig.5 shows the results for a smaller instance (Agricultural Planning - II), with 1 stage **and 10 scenarios only. The CP model has**
16 decision variables and 9 constraints for one scenario, and 124 decision variables and 81 constraints for 10 scenarios. The adverse effect of the shorter planning horizon on the effectiveness of scenario reduction techniques is also observed in this case.

![0_image_0.png](0_image_0.png)

## 8.3 Production/Inventory Management

Uncertainty plays a major role in production and inventory management. In this simplified production/inventory planning example, there is a single product, a single stocking point, production capacity constraints and stochastic demand. The objective is to find the minimum expected cost policy. The cost components taken into account are holding costs, backlogging costs, fixed replenishment (or setup)
costs and unit production costs. The optimal policy gives the timing of the replenishments as well as the order-up-to-levels. Hence, the exact order quantity **can be known only after the realization of** the demand, using the scenario dependent order-up-to-level decisions. This test problem has 5 stages 17