# Stochastic Constraint Programming: A Scenario-Based Approach

S. Armagan Tarim, Cork Constraint Computation Centre, University College Cork, Ireland Suresh Manandhar, Department of Computer Science, University of York, United Kingdom Toby Walsh, National ICT Australia and School of Computer Science and Engineering, University of New South Wales, Australia

## Abstract 1

To model combinatorial decision problems involving uncertainty and probability, we introduce scenario based stochastic constraint programming. Stochastic constraint programs contain both decision variables, which we can set, and stochastic variables, which **follow a discrete probability** distribution. We provide a semantics for stochastic constraint programs based on scenario trees.

Using this semantics, we can compile stochastic constraint programs down into conventional (nonstochastic) constraint programs. This allows us to exploit the full power of existing constraint solvers. We have implemented this framework for decision making under uncertainty in stochastic OPL, a language which is based on the OPL constraint modelling language [Hentenryck et al., 1999]. To illustrate the potential of this framework, we model a wide **range of problems in areas** as diverse as portfolio diversification, agricultural planning and production/inventory management. Keywords: constraint programming, constraint satisfaction, reasoning under uncertainty Content areas: constraint programming, constraint satisfaction, reasoning under uncertainty

## 1 Introduction

Many decision problems contain uncertainty. Data about events in the past may not be known exactly due to errors in measuring or difficulties in sampling, whilst **data about events in the future may simply** not be known with certainty. For example, when scheduling power stations, we need to cope with uncertainty in future energy demands. As a second example, nurse rostering in an accident and emergency department requires us to anticipate variability in workload. As a final example, when constructing a balanced bond portfolio, we must deal with uncertainty in the future price of bonds.

To deal with such situations, [27] proposed an extension of constraint programming, called stochastic constraint programming, in which we distinguish between decision variables, which **we are free to set,**
and stochastic (or observed) variables, which follow some probability distribution. A semantics for stochastic constraint programs based on policies was proposed and backtracking and forward checking algorithms to solve such stochastic constraint programs were presented.