scenarios. It will often be impossible or undesirable for all decision variables to be robust. We therefore identify those decision variables whose values we wish to be **identical across scenarios using commands** of the form:

## Robust <Var>;

For example, in production/inventory problem of Sec.8.3 the decision variables "order-up-to-levels" and "replenishment periods" can be declared as robust variables. The values of these two sets of decision variables are then fixed at the beginning of the planning horizon giving a static policy. A robust solution dampens the nervousness of the solution, an area of very active research in production/inventory management. As the expected cost of the robust solution is always higher, the tradeoff between nervousness and cost may have to be taken into account.

According to [18], the optimal solution of the program will be robust with respect to optimality if it remains close to optimal for any realization of the scenario ω ∈ **Ω. It is then termed "solution robust".**
The objective function can be written in the form, min σ(x, yω∈Ω) where x **denotes the deterministic** decision variables, yω∈Ω **is a set of control variables for each scenario.**
There is not a unique form of the above function. As discussed **in Sec.4.3, one typical form can be**
the expected value criterion, σ(.) = Pω∈Ω
pωQω**, in which the objective function of a model becomes**
a random variable taking the value Qω with probability pω**. Another common form is the worst-case**
criterion, σ(.**) = max**ω∈Ω Qω.

Mulvey, Vanderbei and Zenios point out that the expected value and the worst-case functions are special cases in robust optimization, and the tradeoff between mean value and its variability is a novelty of the robust optimization formulation. However, as discussed in Sec.4.3, Markowitz's mean/variance model provides such a framework.

To demonstrate the concept and the use of robustness in stochastic constraint programming, we consider a production/inventory planning problem with demand data provided in Table 2, a production capacity of 40 units/period, and stationary costs: **production/purchasing costs $2/unit, fixed**
ordering (or setup) costs $50/replenishment, inventory holding costs $1/unit/period, backlogging costs $5/unit/period.

D1 D2 D3 D4 Pr{D1} Pr{D2} Pr{D3} Pr{D4}

Period 1 8 10 12 14 **0.20 0.20 0.40 0.20** Period 2 15 18 21 24 **0.30 0.40 0.20 0.10** Period 3 15 20 23 26 **0.10 0.20 0.60 0.10** Period 4 10 15 20 22 **0.50 0.30 0.10 0.10** Period 5 12 18 20 24 **0.30 0.50 0.10 0.10**

Table 2: Demand data Stochastic-CP model, with minimize expected(cost)**, gives the following solution: In Period 1,**
inventory is raised to 33; no replenishment is planned for Period 2; in Period 3, a replenishment is planned with a scenario dependent order-up-to-level varying between 35 to 47; in Period 4, only in one scenario out of 64 there is a replenishment; in the final period, there are replenishments with various order-up-to-levels in 36 scenarios out of 256. The expected **total cost of following the optimal policy** is $351.61.