state and reward depend only on the previous state and action **taken. To represent a stochastic**
constraint program in which the current decision depends on **all earlier decisions would require an** MDP with an exponential number of states. Stochastic constraint optimization can also be used to model more complex reward functions than the (discounted) sum of individual rewards. Another significant difference is that stochastic constraint programs by using a scenario-based interpretation can immediately call upon complex and powerful constraint propagation techniques.

Stochastic constraint programs are also closely related to **influence diagrams. Influence diagrams**
are Bayesian networks in which the chance nodes are augmented with decision and utility nodes [19]. The usual aim is to maximize the sum of the expected utilities. Chance nodes in an influence diagram correspond to stochastic variables in a stochastic constraint program, whilst decision nodes correspond to decision variables. The utility nodes correspond to the cost function in a stochastic constraint optimization problem. However, reasoning about stochastic constraint programs is likely to be easier than about influence diagrams. First, the probabilistic aspect of a stochastic constraint program is simple and decomposable as there are only unary marginal probabilities. Second, the dependencies between decision variables and stochastic variables are represented by declarative constraints. We can therefore borrow from traditional constraint satisfaction and optimization powerful algorithmic techniques like branch and bound, constraint propagation and nogood recording. As a result, if a problem can be modelled within the more restricted format of **a stochastic constraint program, we** hope to be able to reason about it more efficiently.

## 11 Related Work In Constraints 22

Stochastic constraint programming was inspired by both stochastic integer programming and stochastic satisfiability [15]. It is designed to take advantage of some of the best features of each framework. For example, we are able to write expressive models using non-linear and global constraints, and to exploit efficient constraint propagation algorithms. In operations research, scenarios are used in stochastic programming. Indeed, the scenario reduction techniques of Dupacova, Growe-Kuska and Romisch [4] implemented here are borrowed directly from stochastic programming.

Mixed constraint satisfaction [7] is closely related to one **stage stochastic constraint satisfaction.**
In a mixed CSP, the decision variables are set after the stochastic variables are given random values. In addition, the random values are chosen uniformly. In the case of full observability, the aim is to find conditional values for the decision variables in a mixed **CSP so that we satisfy all possible worlds.**
In the case of no observability, the aim is to find values for the decision variables in a mixed CSP so that we satisfy as many possible worlds. An earlier constraint satisfaction model for decision making under uncertainty [6] also included a probability distribution over the space of possible worlds.

Constraint satisfaction has been extended to include probabilistic preferences on the values assigned to variables [25]. Associated with the values for each variable is a probability distribution. A "best" solution to the constraint satisfaction problem is then found. This may be the maximum probability solution (which satisfies the constraints and is most probable), or the maximum expected overlap solution (which is most like the true solution). The latter can be viewed as the solution which has the maximum expected overlap with one generated at random using the probability distribution. The maximum expected overlap solution could be found by solving a suitable one stage stochastic