we want to explore more sophisticated notions of solution robustness (e.g. limiting the range of values used by a decision variable).

## Acknowledgements

S. Armagan Tarim is supported by Science Foundation Ireland **under Grant No. 03/CE3/I405 as** part of the Centre for Telecommunications Value-Chain-Driven Research (CTVR) and Grant No. 00/PI.1/C075, and by EPSRC under GR/R30792. Suresh Manandhar is supported by EPSRC under GR/R30792. We thank the other members of the 4C Lab and APES Research Group.

## Appendix

In this appendix, we present a mathematical formulation of the portfolio diversification problem of Section 8.1. We also give corresponding stochastic and certainty-equivalent OPL representations.

Assume that, we have $W to invest, denoted by decision variables inv[i], in any of i ∈ I **instruments**
(stocks, bonds, etc.) over a planning horizon of N **periods,**

$$\begin{array}{l}{{w e a l t h[1]=W}}\\ {{w e a l t h[p]=\sum_{i\in I}i n v[i,p],\quad p\in\{1,...,N\}}}\end{array}$$

We wish to exceed a wealth of $G **at the end of the planning horizon. To calculate the utility,** we suppose that exceeding $G is equivalent to an income of q**% of the excess while not meeting the goal** is equivalent to borrowing at a cost r**% of the amount short. So, we can write,**

$$\operatorname*{max}E(q\times p o s-r\times n e g)$$ $$p o s-n e g=w e a l t h[N+1]-G$$ $$p o s,n e g\in\mathbb{Z}^{0,+}.$$

The uncertainty in this problem is the rate of return, return**, which is a random variable, on each**
investment in each period.

$$w e a l t h[p+1]\leq\sum_{i\in I}i n v[i,p](1+r e t u r n[i,p]),\quad p\in\{1,...,N\}$$

A stochastic CP model for the above formulation, written in stochastic OPL, is as follows: stoch market[Period] = ...; enum I ...; int N = ...;
range Period [1..N];
range Period_M [1..N+1]; float return[I,Period]^market = ...; var int+ inv[I,Period] in 0..200;