There is also a constraint to determine the total production **in each variation.**

$$\sum_{j=1}^{T}a_{ij}R_{j}=x_{i},\quad\forall i\in\{1,...,N\}.$$
3
And there are two constraints to determine the amount of shortage and scrap for each variation.

 $e_i=\max\{0,x_i-d_i\},\forall i\in\{1,...,N\}$  $b_i=-\min\{0,x_i-d_i\},\forall i\in\{1,...,N\}$. 
Our objective is to minimise the total expected shortage and **scrap costs,**

$$\operatorname*{min}E\left(\sum_{i=1}^{N}c_{p}b_{i}+c_{h}e_{i}\right)$$
$$\left(2\right)$$
 (3)  $\binom{4}{}$  . 
$$({\mathfrak{h}})$$
$$\left({\mathfrak{H}}\right)$$

where E(.) denotes the expectation operator. From Eqs. (3) and (4) it is clear that bi and ei are random variables, since their values depend on the realization of random demand.

Demand uncertainty necessitates carrying buffer-stocks. Overstock leads to high inventory holding and scrap costs. On the other hand, insufficient buffer stocks are also financially damaging, leading to stock-outs and loss of customer satisfaction. An alternative method to deal with such uncertainty is to introduce service-level constraints instead of using **shortage costs. In this case a service-level** constraint is expressed in the form of a chance constraint as **follows,**

$$\Pr\{x_{i}-d_{i}\geq0\}\geq\alpha_{i},\quad i\in\{1,...,N\}$$
Pr{xi − di ≥ 0} ≥ αi, i ∈ {1, ..., N} (6)
where Pr(.) represents the probability function and α **denotes a target service-level.**
It may also be natural to consider measures such as the worst case performance, other moments of expected performance like variance which is a proxy for risk, the probability of attaining a predetermined performance goal, and even, in certain types of problems like engineering design problem, we may want to minimize the spread (i.e. minimize the difference between the least and the largest value of the objective function). Note that stochastic variables need not be independent (as assumed in [27]). For example, if demand for a certain item is low in the first quarter, it is more likely to be low in the second quarter as well.

Unfortunately, each of these extensions requires a major modification to the backtracking and forward checking algorithms presented in [27]. We therefore take a different track which permits us to define these extensions without major modifications to the **solution methods. We define a new** and equivalent semantics for stochastic constraint programs based on scenarios which permits the above extensions, namely conditional probabilities, multiple chance constraints, as well as a much wider range of goals. This scenario-based view permits stochastic constraint programs to be compiled down into regular (non-stochastic) constraint programs. We can therefore use traditional constraint satisfaction and optimization algorithms, as well as hybrid methods that use techniques like integer linear programming.