
## 3 Scenario-Based Semantics 4

A stochastic constraint satisfaction problem consists of a 6-tuple hV, S, D, P, C, θi. V **is a set of decision**
variables, and S is a set of stochastic variables. D is a function mapping each element of V **and each** element of S **to a domain of potential values. A decision variable in** V is *assigned* **a value from its**
domain. P is a function mapping each element of S **to a probability distribution for its associated**
domain. C is a set of constraints, where a constraint c ∈ C on variables xi, . . . , xj **specifies a subset**
of the Cartesian product D(xi) × . . . × D(xj **) indicating mutually-compatible variable assignments.**
The subset of C that constrain at least one variable in S are *chance constraints*, h. θh **is a threshold**
probability in the interval [0, 1], indicating the fraction of scenarios in which the chance **constraint** h must be satisfied. Note that a chance constraint with a threshold of 1 is equivalent to a hard constraint.

A stochastic CSP consists of a number of *decision stages***. In a one-stage stochastic CSP, the**
decision variables are set before the stochastic variables. In an m-stage stochastic CSP, V and S are partitioned into n disjoint sets, V1, . . . , Vm and S1, . . . , Sm. To solve an m**-stage stochastic CSP an**
assignment to the variables in V1 must be found such that, given random values for S1**, assignments**
can be found for V2 such that, given random values for S2, . . .**, assignments can be found for** Vm so that, given random values for Sm**, the hard constraints are satisfied and the chance constraints are**
satisfied in the specified fraction of all possible scenarios.

In the policy based view of stochastic constraint programs of [27], the semantics is based on a tree of decisions. Each path in a policy represents a different **possible scenario (set of values for the**
stochastic variables), and the values assigned to decision **variables in this scenario. To find satisfying** policies, backtracking and forward checking algorithms, which explores the implicit AND/OR graph, are presented. Stochastic variables give AND nodes as we must find a policy that satisfies all their values, whilst decision variables give OR nodes as we only need find one satisfying value. An alternative semantics for stochastic constraint programs, which suggests an alternative solution method, comes from a scenario-based view [2].

In the scenario-based approach, a scenario tree is generated which incorporates all possible realisations of discrete random variables into the model explicitly. A tree representation of a 3-stage problem, with 2 possible states at each stage, is given in Fig.1.

Scenarios deal with uncertain aspects (e.g. the economic conditions, the state of the financial markets, the level of demand) of the operating environment relevant to the problem. Hence, the future uncertainty is described by a set of alternative scenarios. The number of scenarios as well as the progression of the scenarios from one period to another is problem specific. A path from the root to an extremity of the event tree represents a *scenario*, ω ∈ **Ω, where Ω is the set of all possible**
scenarios. With each scenario a given probability is associated. If Siis the i**th random variable on a**
path from the root to the leaf representing scenario ω, and aiis the value given to Si on the i**th stage**
of this scenario, then the probability of this scenario is again Qi Pr(Si = ai).

Thus, a scenario is associated with each path in the policy. Within each scenario, we have a conventional (non-stochastic) constraint program to solve. We simply replace the stochastic variables by the values taken in the scenario, and ensure that the values found for the decision variables are consistent across scenarios as certain decision variables **are shared across scenarios. For instance, node** 1 of the tree in Figure 1 corresponds to the first stage and associated decisions are identical for all