supported as needed. We insist that stochastic variables are arrays, with the last index describing the stage. Here are two different data representations of stochastic variables:
stoch float market[Years] =
[<0.05 (0.34), 0.07 (0.66)>,<0.02 (0.25), 0.04 (0.25), 0.09 (0.5)>];
stoch int demand[Period] =
[2 (0.25), 3 (0.75), 4 (0.35), 5(0.15), 7 (0.50), 8 (0.40), 9 (0.60)];
In the first, we have a float variable in the first year which is either 0.05 (with probability 0.34) or 0.07
(with probability 0.66). The notation, "< . >**", is convenient for problems in which random variables**
are independent. In the second, we have the stochastic variable demand**, which takes the value of either** 2 or 3 in the first period. The value of the random variable in the second period depends on the first period's realization. It is {4, 5, 7} if the first period's demand is 2, and {8, 9} **if it is 3. This notation**
is convenient especially for problems involving conditional probabilities.

The constants are declared as in OPL with the exception of the **case where their values depend on**
the stochastic variables. In a financial planning problem, if it is assumed that the financial instrument return rates solely depend on unpredictable market then the return matrix **return[Instr,Period]**
must be related to the stochastic variable market[Period]. The dependence of return on **market** is denoted by joining them together by a hat, ˆ, as in return[Instr,Period]^market = ...;

## 4.2 Constraint Posting 7

We can post both hard constraints (as in OPL) and chance constraints. Chance constraints hold in some but not necessarily all scenarios. They are posted using a command of the form:

## Prob(<Constraint>) <Arithop> <Expr>;

Where <Constraint> is any OPL constraint, <ArithOp> **is any of the arithmetically comparison**
operations (=,<>,<,>, <=, or >=) and <Expr> **is any arithmetic expression (it may contain decision**
variables or may just be a rational or a float in the range 0 to 1). For example, the following command specifies the chance constraint that in each quarter the demand (a stochastic variable) does not exceed the production (a decision variable) plus the stock carried **forward in each quarter (this auxiliary is** modelled, as in conventional constraint programming, by a decision variable) with 80% probability:

## Forall(I In 1..N) Prob(Demand[I] <= Production[I]+Stock[I]) >= 0.80;

Constraints which are not chance constraints are hard and have to hold in all possible scenarios. For example, the stock carried forwards is computed via the hard **constraint:**
forall(i in 1..n)
stock[i+1] = max(0,stock[i] + production[i] - demand[i]);