
## 4.3 Optimization 8

Stochastic OPL supports both stochastic constraint satisfaction and optimization problems. We can maximize or minimize the expectation of an objective function. As an example of an expected value function, we'll consider the stochastic template design problem of Sec.2, in which the expected total cost of scrap and shortage is minimised. This can be specified **by the following (partial) model:**
minimize expected(cost) subject to cost = sum(i in 1..n) ch*max(0,x[i]-d[i])-cp*min(0,x[i]-d[i]); ...

We can also model risk. For example, we may wish to reason about the mean and variance in the return for a portfolio selection problem [16]. Markowitz's **mean/variance model provides a framework** to examine the tradeoff between the expected value and its variability. In the mean/variance model, the expected value plus a constant (λ ≤ **0) times the standard deviation –standard deviation is used**
as a surrogate for risk– is maximized. However, since the risk expression of Markowitz is very complex to reason with, we consider the simplification introduced in **[11] and [12].**
In [12], the absolute deviation function, K, is introduced as K = |Q − E{Q}|**, where the random**
variable Q denotes the objective function value. [11] demonstrates that mean absolute deviation function can remove most of the difficulties associated with the standard deviation function. Stochastic OPL supports Markowitz's mean/variance model, where the surrogate risk measure is the absolute deviation function, with the command:
maximize mv(<Expr>,λ)
The mean absolute deviation risk model is discussed in Sec.9.

Stochastic OPL also supports a number of other optimization **goals. For example:**
minimize spread(profit) maximize downside(profit) minimize upside(cost)
The spread is the difference between the value of the objective **function in the best and worst scenarios,**
whilst the downside (upside) is the minimum (maximum) objective function value a possible scenario may take.

## 5 Compilation Of Stochastic Opl

These stochastic extensions are compiled down into conventional (non-stochastic) OPL models automatically by exploiting the scenario-based semantics. The **compiler is written in Lex and Yacc, with** a graphical interface in Visual C++. A demonstration version of the stochastic OPL compiler and example problems can be downloaded from http://www.cs.york.ac.uk/∼**at/project. In what follows,** the compilation of decision variables, constants, hard constraints, chance constraints and objective functions are discussed.