
## 6 Complete Algorithms

We present a backtracking algorithm for solving stochastic CSPs, which is then extended to a forward checking procedure.

## 6.1 Backtracking

We assume that variables are instantiated in order. However, if decision variables occur together, they can be instantiated in any order.

A branching heuristic like fail first may therefore be used to order decision variables which occur together. On meeting a decision variable, the backtracking (BT) algorithm tries each value in its domain in turn. The maximum value is returned to the previous recursive call. On meeting a stochastic variable, we try each value in turn, and returns the sum of the all answers to the subproblems weighted by the probabilities of their occurrence. At any time, if instantiating a decision or stochastic variable breaks a constraint, we return 0. If we manage to instantiate all the variables without breaking any constraint, we return 1.

![0_image_1.png](0_image_1.png)

  **if**$consistent(x_{i}\to d_{j})$**then**  $\theta:=\theta+p\times$ BT($i+1,\frac{\theta_{1}-\theta-q}{p},\frac{\theta_{1}-\theta}{p})$  **if**$\theta>\theta_{h}$**then** return**$\theta$  **if**$\theta+q<\theta_{1}$**then** return**$\theta$  **if**$consistent(x_{i}\to d_{j})$**then**  $\theta:=$ max($\theta$,BT($i+1$,max($\theta,\theta_{1})$,$\theta_{h})$)  **if**$\theta>\theta_{h}$**then**return**$\theta$  **if**$\theta>\theta_{h}$**then**return**$\theta$
else
return θ
$\begin{array}{c}\mbox{\bf if}\ \theta\ >\ \theta_{h}\ \mbox{\bf then return}\ \theta\\ \mbox{\bf if}\ \theta\ +\ q\ <\ \theta_{1}\ \mbox{\bf then return}\ \theta\end{array}$
Figure 1. The backtracking (BT) algorithm is called with the search depth, i and with bounds, θh and θl. If the optimal satisfaction lies between these bounds, BT returns the exact satisfaction. If the optimal satisfaction is θh or more, BT returns a value greater than or equal to θh. If the optimal satisfaction is θl or less, BT returns a value less than or equal to θl. S is the set of stochastic variables.

Upper and lower bounds, θh and θl are used to prune search. By setting θl = θh = θ, we can determine if the optimal satisfaction is at least θ. Alternatively, by setting θl = 0 and θh = 1, we can determine the optimal satisfaction. The calculation of upper and lower bounds in recursive calls requires some explanation. Suppose that the current assignment to a stochastic variable returns a satisfaction of θ0. We can safely ignore other values for this stochastic variable if θ + p × θ0 ≥ θh. That is, if θ0 ≥
θh−θ p. This gives the upper bound in the recursive call to BT on a stochastic variable. Alternatively, we cannot hope to satisfy the constraints adequately if θ+p×θ0+q ≤ θl as q is the maximum that the remaining values can contribute to the satisfaction. That is, if θ0 ≤
θl−θ−q p. This gives the lower bound in the recursive call to BT on a stochastic variable. Finally, suppose that the current assignment to a decision variable returns a satisfaction of θ. If this is more that θl, then any other values must exceed θ to be part of a better policy. Hence, we can replace the lower bound in the recursive call to BT on a decision variable by max(**θ, θ**l). Because of these bounds, value ordering heuristics can reduce search. For decision variables, we should choose values that are likely to return the optimal satisfaction. For stochastic variables, we should choose values that are more likely.

## 6.2 Forward Checking

The Forward Checking (FC) procedure is based on the BT algorithm.

On instantiating a decision or stochastic variable, the FC algorithm checks forward and prunes values from the domains of future decision and stochastic variables which break constraints. Checking forwards fails if a stochastic or decision variable has a domain wipeout
(dwo), or if a stochastic variable has so many values removed that we cannot hope to satisfy the constraints. As in the regular forward checking algorithm, we can use an 2-dimensional array, prune(**i, j**)
to record the depth at which the value dj for the variable xi is removed by forward checking. This is used to restore values on backtracking. In addition, each stochastic variable, xi has an upper bound, qi on the probability that the values left in its domain can contribute to a solution. When forward checking removes some value, dj from xi, we reduce qi by **prob**(xi → dj ), the probability that xi takes the value dj . This reduction on qj is undone on backtracking. If forward checking ever reduces qi to less than θl , we backtrack as it is impossible to set xi and satisfy the constraints adequately.

![0_image_0.png](0_image_0.png)

θ := θ + p× FC(i + 1, θl−θ−qi p, θh−θ p) restore(i) if θ + qi < θl then return θ if θ > θh then return θ else θ := max(θ,FC(i + 1,max(θ, θl),θh)) restore(i) if θ > θh then return θ else restore(i)
$\mathbf{a}$
return θ
procedure restore(i)
for j = i + 1 to n
Figure 2. The forward checking (FC) algorithm is called with the search
depth, i and bounds, θh and θl. If the maximum satisfaction of all policies
lies between these bounds, FC returns the exact maximum satisfaction. If the
maximum satisfaction of all policies is θh or more, FC returns a value greater than or equal to θh. If the minimum satisfaction of all policies is θl or less,
FC returns a value less than or equal to θl. S is the set of stochastic variables.
The array qi is an upper bound on the probability that the stochastic variable
xi satisfies the constraints and is initially set to 1, whilst prune(i, d) is the depth at which the value d is pruned from xi and is initially set to 0 which
indicates that the value is not yet pruned.
for dk ∈ D(xj ) if prune(j, k) = i then prune(j, k) = 0 if xj ∈ S then qj := qj+ prob(xj → dk)
return $0$  procedure check($x_{i}\to d_{j},\theta_{l}$)  for $k=i+1$to $n$  dwo := true  for $d_{l}\in D(x_{k})$  if $prune(k,l)=0$then  if inconsistent($x_{i}\to d_{j},x_{k}\to d_{l}$) then  $prune(k,l):=i$  if $x_{k}\in S$then  $q_{k}:=q_{k}-\mbox{prob}(x_{k}\to d_{l})$  if $q_{k}<\theta_{l}$ then return false  else dwo := false  if dwo then return false  return true 

## 7 Experimental Evaluation

We implemented the BT and FC algorithms in Common Lisp and ran them on the production planning problem given in Section 3, as well