as on a range of randomly generated problems. For the production plannng problem, we use a simple heuristic which orders values for the decision variables by their size. This will tend to keep stock levels low. It will also ensure that the worlds in which we fail to satisfy the demand constraints are those where demand is much higher than average. Results are given in Table 1 with the threshold for satisfiability θ set to 0.8. Similar results are obtained for other non-zero θ. Surprisingly, performance was relatively insensitive to the precise value of θ used.

Number of BT FC

quarters nodes CPU/sec nodes CPU/sec

1 28 0.01 10 0.01 2 650 0.09 148 0.03 3 17,190 2.72 3,604 0.76 4 510,346 83.81 95,570 19.07 5 15,994,856 3,245.99 2,616,858 509.95

Table 1. Backtracking (BT) and forward checking (FC) algorithms on the

production planning problem from Section 3. CPU times are for a Common Lisp implementation running under Linux on an ancient 133MHz Pentium,

whilst "nodes" are the number of nodes visited in the and/or search tree.

The performance advantage of the FC algorithm over the BT algorithm increases as the stochastic CSP increases in size. On the largest problem in Table 1, the FC algorithm visits approximately 1/6th the search nodes in roughly 1/6th the CPU time. This is in line with our results on random problems, where the FC algorithm is often an order of magnitude faster than the BT algorithm. Even larger gains can be expected on problems in which constraints apply to variables which are set far apart in the search tree. On such problems, forward checking will prune domains far down the search tree, thereby avoiding deep backtracks.

Our results show that the FC algorithm clearly dominates the BT
algorithm. Consistency testing and domain pruning ensures that it only visits a small fraction of the possible worlds. Further performance gains could be obtained by more powerful constraint propagation, more intelligent backtracking, and more sophisticated branching heuristics. These are all areas for future work.

## 8 Approximation Procedures

There are a number of methods for approximating the answer to a stochastic constraint program. For example, we can replace the stochastic variables in a stochastic CSP by their most probable values (or in ordered domains like integers by their median or integer mean values), and then solve (or approximate the answer to) the resulting traditional constraint satisfaction problem. Similarly, we can estimate the optimal solution for a stochastic COP by replacing the stochastic variables by their most probable values and then finding
(or approximating the answer to) the resulting traditional constraint optimization problem. We can also use Monte Carlo sampling to test a subset of the possible worlds. For example, we can randomly generate values for the stochastic variables according to their probability distribution. If the fraction of the resulting constraint satisfaction problems that are satisfiable is at least equal to the threshold θ, then the original stochastic constraint satisfaction problem is likely to be satisfiable. It would also be interesting to develop local search procedures like GSAT and WalkSAT [SLM92, SKC94] which explore the
"policy space" of stochastic constraint programs.

## 9 Extensions

We have assumed that stochastic variables are independent. There are problems which may require us to relax this restriction. For example, a stochastic variable representing electricity demand may depend on a stochastic variable representing temperature. It may therefore be useful to combine stochastic programming with techniques like Bayes networks which allow for conditional dependencies to be efficiently and effectively represented. An alternative solution is to replace the dependent stochastic variables by a single stochastic variable whose domain is the product space of the dependent variables.

This is only feasible when there are a small number of dependent variables with small domains.

We have also assumed that the probability distribution of stochastic variables is fixed, and does not depend on earlier decision variables. Again, there are problems which may require us to relax this restriction. For example, the decision variable representing price may influence a stochastic variable representing demand. A solution may again be to combine stochastic programming with techniques like Bayes networks. We have also assumed that the probability distribution is known in advance. It would be interesting to explore methods for estimating it based on observation.

Finally, we have assumed that all variable domains are finite.

There are problems which may require us to relax this restriction. For example, in scheduling power stations, we may use 0/1 decision variables to model whether a power station runs or not, but have continuous (observed) variables to model future electricity demands. A continuous probability density function could be associated with these variables. Similarly, a continuous decision variable could be useful to model the power output. Interval reasoning techniques could be extended to deal with such variables.

## 10 Related Work In Decision Making Under Uncertainty

Stochastic constraint programs are closely related to Markov decision problems (MDPs). An MDP model consists of a set of states, a set of actions, a state transition function which gives the probability of moving between two states as a result of a given action, and a reward function. A solution to an MDP is a policy, which specifies the best action to take in each possible state. MDPs These have been very influential in AI of late for dealing with situations involving reasoning under uncertainty [Put94]. Stochastic constraint programs can model problems which lack the Markov property that the next state and reward depend only on the previous state and action taken.

To represent a stochastic constraint program in which the current decision depends on all earlier decisions would require an MDP with an exponential number of states. Stochastic constraint optimization can also be used to model more complex reward functions than the
(discounted) sum of individual rewards.

Stochastic constraint programs are also closely related to influence diagrams. Influence diagrams are Bayesian networks in which the chance nodes are augmented with decision and utility nodes
[OS90]. The usual aim is to maximize the sum of the expected utilities. Chance nodes in an influence diagram correspond to stochastic variables in a stochastic constraint program, whilst decision nodes correspond to decision variables. The utility nodes correspond to the cost function in a stochastic constraint optimization problem. It would therefore be relatively straightforward to map stochastic constraint programs into influence diagrams. However, reasoning about stochastic constraint programs is likely to be easier than about in-