fluence diagrams. First, the probabilistic aspect of a stochastic constraint program is simple and decomposable as there are only unary marginal probabilities. Second, the dependencies between decision variables and stochastic variables are represented by declarative constraints. We can therefore borrow from traditional constraint satisfaction and optimization powerful algorithmic techniques like branch and bound, constraint propagation and nogood recording. As a result, if a problem can be modelled within the more restricted format of a stochastic constraint program, we hope to be able to reason about it more efficiently.

## 11 Related Work In Constraints

Stochastic constraint programming is inspired by both stochastic integer programming and stochastic satisfiability [LMP00]. It shares the advantages that constraint programming has over integer programming (e.g. non-linear constraints, and constraint propagation).

It also shares the advantages that constraint programming has over satisfiability (e.g. global and arithmetic constraints, and more compact models).

Mixed constraint satisfaction [FLS96] is closely related to one stage stochastic constraint satisfaction. In a mixed CSP, the decision variables are set after the stochastic variables are given random values. In addition, the random values are chosen uniformly. In the case of full observability, the aim is to find conditional values for the decision variables in a mixed CSP so that we satisfy all possible worlds.

In the case of no observability, the aim is to find values for the decision variables in a mixed CSP so that we satisfy as many possible worlds. An earlier constraint satisfaction model for decision making under uncertainty [FLMCS95] also included a probability distribution over the space of possible worlds.

Constraint satisfaction has been extended to include probabilistic preferences on the values assigned to variables [SLK99]. Associated with the values for each variable is a probability distribution. A
"best" solution to the constraint satisfaction problem is then found.

This may be the maximum probability solution (which satisfies the constraints and is most probable), or the maximum expected overlap solution (which is most like the true solution). The latter can be viewed as the solution which has the maximum expected overlap with one generated at random using the probability distribution.

The maximum expected overlap solution could be found by solving a suitable one stage stochastic constraint optimization problem.

Branching constraint satisfaction [FB00] models problems in which there is uncertainty in the number of variables. For example, we can model a nurse rostering problem by assigning shifts to nurses.

Branching constraint satisfaction then allows us to deal with the uncertainty in which nurses are available for duty. We can represent such problems with a stochastic CSP with a stochastic 0/1 variable for each nurse representing their availability.

A number of extensions of the traditional constraint satisfaction problem model constraints that are uncertain, probabilistic or not necessarily satisfied. For example, in partial constraint satisfaction we maximize the number of constraints satisfied [FW92]. As a second example, in probabilistic constraint satisfaction each constraint has a certain probability independent of all other probabilities of being part of the problem [FL93]. As a third example, both valued and semi-ring based constraint satisfaction [BFM+96] generalizes probabilistic constraint satisfaction as well as a number of other frameworks. In semi-ring based constraint satisfaction, a value is associated with each tuple in a constraint, whilst in valued constraint satisfaction, a value is associated with each constraint. However, none of these extensions deal with variables that may have uncertain or probabilistic values. Indeed, stochastic constraint programming can easily be combined with most of these techniques. For example, we can define stochastic partial constraint satisfaction in which we maximize the number of satisfied constraints, or stochastic probabilistic constraint satisfaction in which each constraint has an associated probability of being in the problem.

## 12 Conclusions

We have proposed stochastic constraint programming, an extension of constraint programming to deal with both decision variables
(which we can set) and stochastic variables (which follow some probability distribution). This framework is designed to take advantage of the best features of traditional constraint satisfaction, stochastic integer programming, and stochastic satisfiability. It can be used to model a wide variety of decision problems involving uncertainty and probability. We have given a semantics for stochastic constraint programs based upon policies. These determine how decision variables are set depending on earlier decision and stochastic variables. We have proposed a number of complete algorithms and approximation procedures for stochastic constraint programming. Finally, we have discussed a number of extensions of stochastic constraint programming to relax assumptions like the independence between stochastic variables, and compared it with other approaches for decision making under uncertainty like Markov decision problems and influence diagrams.

## References

[BFM+96] S. Bistarelli, H. Fargier, U. Montanari, F. Rossi, T. Schiex, and G. Verfaillie. Semi-ring based CSPs and valued CSPs: Basic properties and comparison. *Over-Constrained Systems*, pages 111–150. Springer-Verlag, 1996. LNCS 1106.

[FB00] D. Fowler and K. Brown. Branching constraint satisfaction problems for solutions robust under likely changes. In Proc.

of 6th Int. Conf. on Principles and Practices of Constraint Programming. Springer-Verlag, 2000.

[FL93] H. Fargier and J. Lang. Uncertainty in constraint satisfaction problems: a probabilistic approac h. In *Proc. of ECSQARU*.

Springer-Verlag, 1993. LNCS 747.

[FLMCS95] H. Fargier, J. Lang, R. Martin-Clouaire, and T. Schiex. A constraint satisfaction framework for decision under uncertainty.

In *Proc. of the 11th Int. Conf. on Uncertainty in AI*, 1995.

[FLS96] H. Fargier, J. Lang, and T. Schiex. Mixed constraint satisfaction: a framework for decision problems under in complete information. In *Proc. of the 13th Nat. Conf. on AI*. 1996.

[FW92] E. Freuder and R. Wallace. Partial constraint satisfaction. *Artificial Intelligence*, 58:21–70, 1992.

[LGM98] Michael L. Littman, Judy Goldsmith, and Martin Mundhenk.

The computational complexity of probabilistic plan existence and evaluation. *J. of AI Research*, 9:1–36, 1998.

[LMP00] M.L. Littman, S.M. Majercik, and T. Pitassi. Stochastic Boolean satisfiability. *J. of Automated Reasoning*, 2000.

[OS90] R.M. Oliver and J.Q. Smith. *Influence Diagrams, Belief Nets* and Decision Analysis. John Wiley and Sons, 1990.

[Put94] M.L. Puterman. Markov decision processes: discrete stochastic dynamic programming. John Wiley and Sons, 1994.

[SKC94] B. Selman, H. Kautz, and B. Cohen. Noise Strategies for Improving Local Search. In *Proc. of the 12th Nat. Conf. on AI*,
pages 337–343. 1994.

[SLK99] N. Shazeer, M. Littman, and G. Keim. Constraint satisfaction with probabilistic preferences on variable values. In *Proc. of* the 16th Nat. Conf. on AI. 1999.

[SLM92] B. Selman, H. Levesque, and D. Mitchell. A New Method for Solving Hard Satisfiability Problems. In Proc. of the 10th Nat. Conf. on AI, pages 440–446. 1992.