of stable models of normal logic programs. There are many characterizations of stable models of logic programs. In fact, in (Lifschitz 2008), Lifschitz lists twelve different characterizations of stable models of logic programs. The characterization of stable models that we present in this paper has a distinctly proof-theoretic flavor and makes easy to prove some basic results on Answer Set Programming **such as Fages'** Theorem (Fages 1994), Erdem-Lifschitz Theorem (Erdem and Lifschitz 2003), and Dung's Theorem (Dung and Kanchansut 1989).

It should be observed that in (Dung and Kanchansut 1989) Dung and Kanchansut consider so-called quasi-interpretations which, in the formalism **of our paper,**
can be viewed as collections of guarded atoms. The difference between our approach and that of (Dung and Kanchansut 1989) is that we elucidate the proof theoretic content of the Gelfond-Lifschitz operator and show how this technique allows for uniform proof of various results in the theory of stable models of programs.

The outline of this paper is as follows. First, we introduce the definition of the guarded resolution rule of proof and then derive its connections with the GelfondLifschitz operator (Gelfond and Lifschitz 1988). Once we do this, we will obtain the desired lifting of the classical result on the completeness of positive **unit resolution** for Horn theories (Dowling and Gallier 1984) to the context of the stable semantics of logic programs. In Section 3, we show how guarded resolution proofs can be used to prove various standard results in the theory of stable models of **propositional**
programs. Finally, in Section 4, we show how the theory developed in this paper can be used to obtain an algorithm for computation of stable models that does not use loop formulas and runs in polynomial space in the size of the program.

## 2 Guarded Resolution And Stable Semantics

By a logic program clause**, we mean a string of the form**

$$(1)$$
$$r_{1},\ldots,n o t\ r_{m}.$$

C = p ← q1**, . . . , , q**n, not r1**, . . . ,** not rm. (1)
A program P **is a set of logic program clauses.**
We will interpret program clause C **given in (1) as a guarded Horn clause:**
g(C) = p ← q1, . . . , , qn : {r1**, . . . , r**m}.

We define g(P) = {g(C) : C ∈ P}**. Observe that when we interpret a logic program**
clause as a guarded Horn clause, the polarity of atoms appearing negatively in the body of the programming clause changes in its representation as the guarded Horn clause. That is, they occurred negatively **in the body of clause and they now**
appear positively **in the guard. By convention, we think of a propositional atom as**
a guarded atom with an empty guard.

We now introduce our guarded resolution rule as follows. It has two arguments:
the first is a guarded Horn clause and the second is a guarded atom q : {r1**, . . . , r**n}.

The guarded atom q **must occur in the body of the guarded Horn clause. The result** of the application of the rule is a guarded Horn clause whose body is the body of the original guarded Horn clause minus the atom q**. The guard of the resulting**
guarded Horn clause is the union of the guard of the guarded atom and the guard