of the original guarded Horn clause. Formally, our guarded resolution rule has the following form:
p ← q1, . . . , , qn : {r1, . . . , rm} qj : {s1**, . . . , s**h}
p ← q1, . . . , qj−1, qj+1, . . . , qn : {r1, . . . , rm, s1**, . . . , s**h}
.

Next, we discuss the Gelfond-Lifschitz operator associated with a normal propositional program. Given a set of atoms M and a normal logic program P**, we first**
define the Gelfond-Lifschitz reduct P M of P. P M **is constructed according to the**
following two step process. First, if C = p ← q1**, . . . , , q**n, not r1**, . . . ,** not rm is a clause in P and rj ∈ M for some 1 ≤ j ≤ m, then we eliminate C**. Second, if**
C **is not eliminated after step 1, then we replace** C by p ← q1**, . . . , q**n.

Clearly, P M is a Horn program. Thus P M has a least model NM. The GelfondLifschitz operator assigns to M **the set of atoms** NM.

Our guarded unit resolution rule naturally leads to the notion of a guarded resolution proof P of a guarded atom p : S from the program P. Here S **is a, possibly**
empty, set of atoms. That is, a guarded resolution proof of p : S **is a labeled tree** such that every node that is not a leaf has two parents, one labeled **with a guarded** Horn clause and the other labeled with a guarded atom, where the label of the node is the result of executing the guarded unit resolution rule on the labels of the parents. Each leaf is either a guarded Horn clause p ← q1, . . . , , qn : {r1, . . . , rm} **such**
that p ← q1**, . . . , , q**n, not r1**, . . . ,** not rm is in P or a guarded atom q : {r1**, . . . , r**m}
such that q ← not r1**, . . . ,** not rm is in P. In the special case where the tree consist of a single node, we assume that the node is labeled with a guarded **atom**
q : {r1, . . . , rm} **where** q ← not r1**, . . . ,** not rm is in P**. Note that in a guarded**
resolution proof, guards only grow as we proceed down the tree. That is, as we resolve, the guards are summed up. For this reason, the guard of **the root of the**
proof contains the guards of every **label in the tree.**
We say that a set of atoms M admits a guarded atom p : S, if M ∩ S = ∅ and that M admits a guarded resolution proof P **if it admits the label of the root of** P**. The following statement follows from the containment properties of guards in a** guarded resolution proof.

## Lemma 2.1

If M admits the guarded resolution proof P, then M **admits every guarded atom** occurring as a label in P and M **is disjoint from the guard of every guarded clause**
in P.

We then have the following proposition.

## Proposition 2.1

Let P be a propositional logic program and let M **be a set of atoms. Then** GLP (M)
consists exactly of atoms p such that there exists a set of atoms Z where the guarded