
## 4.1 Continuity Properties Of Monotone And Antimonotone Operators

Let us recall that P(At) denotes the set of all subsets of At. We say that any function O : P(At) → P(At) is an operator on the set At of propositional atoms.

An operator O is *monotone* if for all sets **X, Y** ⊆ At, X ⊆ Y implies O(X) ⊆ O(Y ). Likewise an operator O is *antimonotone* if for all sets **X, Y** ⊆ At, X ⊆ Y
implies O(Y ) ⊆ O(X). For a sequence hXnin∈N of sets of atoms, we say that hXnin∈N is *monotonically increasing* if for all **i, j** ∈ N, i ≤ j implies Xi ⊆ Xj and we say that hXnin∈N is *monotonically decreasing* if for all **i, j** ∈ N, i ≤ j implies Xj ⊆ Xi.

There are four distinct classes of operators that we shall consider in this paper. First, we shall consider two types of monotone operators, upper-half continuous monotone operators and lower-half continuous monotone operators. That is, we say that a monotone operator O is *upper-half continuous* if for every monotonically increasing sequence hXnin∈N , O(Sn∈N Xn) = Sn∈N O(Xn). We say that a monotone operator O is *lower-half continuous* if for every monotonically decreasing sequence hXnin∈N , O(Tn∈N Xn) = Tn∈N O(Xn). In the Logic Programming literature the first of these properties is called *continuity*. The classic result due to van Emden and Kowalski is the following.

Proposition 4.1 For every Horn program P, the operator TP *is upper-half continuous.*
In general, the operator TP for Horn programs is not lower-half continuous. For example, let P be the program consisting of the clauses p ← pi for i ∈ N. Then the operator TP is not lower-half continuous. That is, if Xi = {pi, pi+1**, . . .**}, then clearly p ∈ TP (Xi) for all i. However, Ti Xi = ∅ and p 6∈ TP (∅).

Lower-half continuous monotone operators have appeared in the Logic Programming literature [Do94]. Even more generally, for a monotone operator O, let us define its *dual* operator Odas follows:
O
d(X) = At \ O(At \ X).

Then an operator O is upper-half continuous if and only if Odis lower-half continuous [JT51]. Therefore, for any Horn program P, the operator T
d P
is lower-half continuous.

In case of antimonotone operators, we have two additional notions of continuity.

We say an antimonotone operator O is *upper-half* continuous if for every monotonically increasing sequence hXnin∈N , O(Sn∈N Xn) = Tn∈N O(Xn). Similarly, we say an antimonotone operator O is *lower-half* continuous if for every monotonically decreasing sequence hXnin∈N , O(Tn∈N Xn) = Sn∈N O(Xn).