propagation. On the other hand, there are global constraints where decompositions have been given that do not hinder propagation. For example, Beldiceanu *et al.* identify conditions under which global constraints specified as automata can be decomposed into signature and transition constraints without hindering propagation [Beldiceanu *et al.*, 2005].

As a second example, many global constraints can be decomposed using ROOTS and RANGE which can themselves often be propagated effectively using simple decompositions [Bessiere *et al.*, 2005; Bessiere *et al.*, 2006a; Bessiere *et al.*, 2006b]. As a third example, decompositions of the REGULAR and CFG constraints have been given that do not hinder propagation [Quimper and Walsh, 2006; Quimper and Walsh, 2007; Quimper and Walsh, 2008; Bessiere *et al.*, 2008; Katsirelos *et al.*, 2008]. As a fourth example, decompositions of the SEQUENCE constraint have been shown to be effective [Brand *et al.*, 2007]. Finally, the PRECEDENCE constraint can be decomposed into ternary constraints without hindering propagation [Walsh, 2006].

## 8 Conclusions

We have shown that some common global constraints like ALL-DIFFERENT and GCC can be decomposed into simple arithmetic constraints whilst still maintaining a global view that achieves range or bound consistency. These decompositions are interesting for a number of reasons. First, we can easily incorporate them into other solvers. Second, the decompositions provide other constraints with access to the state of the propagator. Third, these decompositions provide a fresh perspective on propagation of global constraints. For instance, our results suggest that it may pay to focus propagation and nogood learning on small Hall intervals. Finally, these decompositions raise an important question. Are there propagation algorithms that cannot be efficiently simulated using decompositions? In [Bessiere *et al.*, 2009], we use circuit complexity to argue that a domain consistency propagator for the ALL-DIFFERENT constraint cannot be simulated using a polynomial sized decomposition.

## References

[Beldiceanu *et al.*, 2004] N. Beldiceanu, I. Katriel, and S. Thiel.

Filtering algorithms for the same constraint. In *1st Int. Conf.* on Integration of AI and OR Techniques in CP, 65–79, 2004.

[Beldiceanu *et al.*, 2005] N. Beldiceanu, I. Katriel, and S. Thiel.

Reformulation of Global Constraints Based on Constraints Checkers Filtering algorithms for the same constraint. *Constraints*, 10(4): 339–362, 2005.

[Bessiere *et al.*, 2005] C. Bessiere, E. Hebrard, B. Hnich, Z. Kiziltan and T. Walsh. The Range and Roots Constraints: Specifying Counting and Occurrence Problems. In *19th Int. Joint Conf. on* AI, 60–65. 2005.

[Bessiere *et al.*, 2006a] C. Bessiere, E. Hebrard, B. Hnich, Z. Kiziltan and T. Walsh. The RANGE Constraint: Algorithms and Implementation. In *3rd Int. Conf. on Integration of AI and OR Techniques in CP (CP-AI-OR)*, 59–73, 2006.

[Bessiere *et al.*, 2006b] C. Bessiere, E. Hebrard, B. Hnich, Z. Kiziltan and T. Walsh. The ROOTS Constraint. In 12th Int. Conf. on Principles and Practices of CP (CP2006), 75–90. 2006.
[Bessiere *et al.*, 2008] C. Bessiere, E. Hebrard, B. Hnich, Z. Kiziltan and T. Walsh. SLIDE: A Useful Special Case of the CARDPATH Constraint. In *18th European Conf. on AI*, 475–479. 2008.

[Bessiere *et al.*, 2009] C. Bessiere, G. Katsirelos, N. Narodytska and T. Walsh. Circuit Complexity and Decompositions of Global Constraints. In *21st Int. Joint Conf. on AI*. 2009.

[Brand *et al.*, 2007] S. Brand, N. Narodytska, C-G. Quimper, P.

Stuckey and T. Walsh. Encodings of the SEQUENCE Constraint.

In *13th Int. Conf. on Principles and Practice of CP (CP2007)*, 210–224. 2007.

[Katriel and Thiel, 2003] I. Katriel and S. Thiel. A fast bound consistency for the global cardinality constraint. In 9th Int. Conf. on Principles and Practice of CP (CP2003). 2003.

[Katsirelos *et al.*, 2008] G. Katsirelos, N. Narodytska and T. Walsh.

The Weighted CFG Constraint. In 5th Int. Conf. on Integration of AI and OR Techniques in CP (CP-AI-OR), 323–327, 2008.

[Lauriere, 1978] J.L. Lauriere. Alice: A language and a program for solving combinatorial problems. *Artificial Intelligence*,
10:29–127, 1978.

[Leconte, 1996] M. Leconte. A bounds-based reduction scheme for constraints of difference. In *2nd Int. Workshop on Constraintbased Reasoning*, 1996.

[Lopez-Ortiz *et al.*, 2003] A. Lopez-Ortiz, C.G. Quimper, J. Tromp, and P. van Beek. A fast and simple algorithm for bounds consistency of the alldifferent constraint. In 18th National Conf. on AI. AAAI 2003.

[Mehlhorn and Thiel, 2000] K. Mehlhorn and S. Thiel. Faster algorithms for bound-consistency of the sortedness and the alldifferent constraint. In 6th Int. Conf. on Principles and Practice of CP
(CP2000), 306–319. 2000.

[Ohrimenko *et al.*, 2007] O. Ohrimenko, P.J. Stuckey, and M. Codish. Propagation = lazy clause generation. In 13th Int.

Conf. Principles and Practice of CP (CP2007), 544–558, 2007.

[Oplobedu *et al.*, 1989] A. Oplobedu, J. Marcovitch, and Y. Tourbier. CHARME: Un langage industriel de programmation par contraintes, illustre par une application chez Renault. In 9th Int. Workshop on Expert Systems and their Applications, 1989.

[Petrie and Smith, 2003] K.E. Petrie and B.M. Smith. Symmetry breaking in graceful graphs. In 9th Int. Conf. of Principles and Practice of CP (CP2003), 930–934, 2003.

[Puget, 1998] J.F. Puget. A fast algorithm for the bound consistency of alldiff constraints. In *15th National Conf. on AI*, 359–366.

AAAI, 1998.

[Quimper and Walsh, 2006] C.-G. Quimper and T. Walsh. Global Grammar Constraints. In *12th Int. Conf. on Principles and Practices of CP (CP2006)*, 751–755. 2006.

[Quimper and Walsh, 2007] C.-G. Quimper and T. Walsh. Decomposing Global Grammar Constraints. In *13th Int. Conf. on Principles and Practices of CP (CP2007)*, 590–604. 2007.

[Quimper and Walsh, 2008] C.-G. Quimper and T. Walsh. Decompositions of Grammar Constraints. In *23rd National Conf. on AI*,
1567–1570. AAAI, 2008.

[Quimper *et al.*, 2004] C-.G. Quimper, P. van Beek, A. LopezOrtiz, and A. Golynski. Improved algorithms for the global cardinality constraint. In *10th Int. Conf. on Principles and Practice* of CP (CP2004). 2004.

[Quimper *et al.*, 2005] C-G. Quimper, A. Golynski, A. L´opezOrtiz, and P. van Beek. An efficient bounds consistency algorithm for the global cardinality constraint. *Constraints*,
10(2):115–135, 2005.

[R´egin, 1994] J-C. R´egin. A filtering algorithm for constraints of difference in CSPs. In *12th National Conf. on AI*, 362–367.

AAAI, 1994.