# Scenario-Based Stochastic Constraint Programming

Suresh Manandhar and **Armagan Tarim**
Department of Computer Science University of York, England email: {suresh,at}@cs.york.ac.uk

# Toby Walsh

Cork Constraint Computation Centre University College Cork, Ireland.

email: tw@4c.ucc.ie.

## Abstract

To model combinatorial decision problems involving uncertainty and probability, we extend the stochastic constraint programming framework proposed in [Walsh, 2002] along a number of important dimensions (e.g. to multiple chance constraints and to a range of new objectives). We also provide a new (but equivalent) semantics based on scenarios.

Using this semantics, we can compile stochastic constraint programs down into conventional (nonstochastic) constraint programs. This allows us to exploit the full power of existing constraint solvers.

We have implemented this framework for decision making under uncertainty in stochastic OPL, a language which is based on the OPL constraint modelling language [Hentenryck *et al.*, 1999]. To illustrate the potential of this framework, we model a wide range of problems in areas as diverse as finance, agriculture and production.

## 1 Introduction

Many decision problems contain uncertainty. Data about events in the past may not be known exactly due to errors in measuring or difficulties in sampling, whilst data about events in the future may simply not be known with certainty. For example, when scheduling power stations, we need to cope with uncertainty in future energy demands. As a second example, nurse rostering in an accident and emergency department requires us to anticipate variability in workload. As a final example, when constructing a balanced bond portfolio, we must deal with uncertainty in the future price of bonds. To deal with such situations, [Walsh, 2002] has proposed an extension of constraint programming, called *stochastic constraint* programming, in which we distinguish between decision variables, which we are free to set, and stochastic (or observed)
variables, which follow some probability distribution. This framework combines together some of the best features of traditional constraint satisfaction, stochastic integer programming, and stochastic satisfiability.

In this paper, we extend the expressivity of this framework considerably by adding multiple chance constraints, as well as a range of objective functions like maximizing the downside. We show how such stochastic constraint programs can be compiled down into conventional (non-stochastic) constraint programs using a scenario-based interpretation. This compilation allows us to use existing constraint solvers without any modification, as well as call upon the power of hybrid solvers which combine constraint solving and integer programming techniques. We also propose a number of techniques to reduce the number of scenarios and to generate robust solutions. We have implemented this framework for decision making under uncertainty in a language called stochastic OPL. This is an extension of the OPL constraint modelling language [Hentenryck *et al.*, 1999]. Finally, we describe a wide range of problems that we have modelled in stochastic OPL that illustrate some of its potential.

## 2 Stochastic Constraint Programs

In a one stage stochastic constraint satisfaction problem (stochastic CSP), the decision variables are set before the stochastic variables. The stochastic variables, independent of the decision variables, take values with probabilities given by a probability distribution. This models situations where we act now and observe later. For example, we have to decide now which nurses to have on duty and will only later discover the actual workload. We can easily invert the instantiation order if the application demands, with the stochastic variables set before the decision variables. Constraints are defined (as in traditional constraint satisfaction) by relations of allowed tuples of values. Constraints can, however, be implemented with specialized and efficient algorithms for consistency checking.

We allow for both hard constraints which are always satisfied and "chance constraints" which may only be satisfied in some of the possible worlds. Each chance constraint has a threshold, θ and the constraint must be satisfied in at least a fraction θ of the worlds. A one stage stochastic CSP is satisfiable iff there exists values for the decision variables so that, given random values for the stochastic variables, the hard constraints are always satisfied and the chance constraints are satisfied in at least the given fraction of worlds. Note that
[Walsh, 2002] only allowed for one (global) chance constraint so the definition here of stochastic constraint programming is strictly more general.

In a two stage stochastic CSP, there are two sets of decision variables, Vd1 and Vd2, and two sets of stochastic variables, Vs1 and Vs2. The aim is to find values for the variables in Vd1,