prob(<Constraint>) <ArithOp> <Expr>;
Where **<Constraint>** is any OPL constraint, <ArithOp> is any of the arithmetically comparison
operations (=,<>,<,>, <=, or >=) and **<Expr>** is any arithmetic expression (it may contain decision variables or may
just be a rational or a float in the range 0 to 1). For example,
the following command specifies the chance constraint that in each quarter the demand (a stochastic variable) does not
exceed the production (a decision variable) plus the stock carried forward in each quarter (this auxiliary is modelled,
as in conventional constraint programming, by a decision variable) with 80% probability:
$$\begin{array}{r l}{\texttt{forall(i in1..n)}}\\ {\texttt{prob(demand[i]<=}}\\ {\texttt{production[i]+stock[i])}}\\ {>=0.80;}\end{array}$$
Constraints which are not chance constraints are hard and
have to hold in all possible scenarios. For example, the stock
carried forwards is computed via the hard constraint:
$$\begin{array}{l}{{\texttt{rall}\texttt{(i in l..n)}}}\\ {{\texttt{stock[i+1]=stock[i]+production[i]}}}\\ {{\texttt{-demand[i];}}}\end{array}$$

## 4.3 Optimization

Stochastic OPL supports both stochastic constraint satisfaction and optimization problems. We can maximize or minimize the expectation of an objective function. For example, in the book production example of [Walsh, 2002], we can minimize the expected cost of storing surplus books. Each book costs $1 per quarter to store. This can be specified by the following (partial) model:
minimize expected(cost)
subject to cost =
sum(i in 1..n) max(stock[i+1],0);
forall(i in 1..n)
stock[i+1] = stock[i] + production[i]
- demand[i];
Stochastic OPL also supports a number of other optimization goals. For example:
minimize spread(profit)
maximize downside(profit) minimize upside(cost)
The spread is the difference between the value of the objective function in the best and worst scenarios, whilst the downside
(upside) is the minimum (maximum) objective function value a possible scenario may take.

## 5 Compilation Of Stochastic Opl

These stochastic extensions are compiled down into conventional (non-stochastic) OPL models automatically by exploiting the scenario-based semantics. The compiler is written in Lex and Yacc, with a graphical interface in Visual C++.

Compilation involves replacing stochastic variables by their possible values, and decision variables by a ragged array of decision variables, one for each possible scenario. Consider again the chance constraint:
prob( demand[i] <= production[i]+stock[i])
>= 0.80; This is compiled into a sum constraint of the form:
sum(j in Scenarios) p[j]*
(demand[i,j] <=
production[i,j]+stock[i,j])
>= 0.80; Where **Scenarios** is the set of scenarios, **p[j]** is the probability of scenario j, **demand[i,j]** is the demand in scenario j and quarter i, etc. Note that the bracketing of the inequality reifies the constraint so that it takes the value 1 if satisfied and 0 otherwise.

Hard constraints are also transformed. Consider, for example, the hard constraint:
wealth[t] = bonds[t] + stocks[t];
This is compiled into a forall constraint of the form:
forall(j in Scenarios)
wealth[t,j] = bonds[t,j] + stocks[t,j];
Where **wealth[t,j]** is the wealth at time t in scenario j, etc. Maximization and minimization instructions are also transformed. Consider, for example, the optimization instruction:
maximize expected(wealth[n]) subject to ...

This is compiled into an instruction of the form:
maximize sum(j in Scenarios)
p[j]*wealth[n,t]
subject to ...

The rest of the stochastic OPL model is transformed in a similar manner.

## 6 Value Of Information And Stochastic Solutions

For stochastic optimization problems, we compute two statistics which quantify the importance of randomness. The value of a stochastic solution (VSS) is the difference in the objective function for the stochastic problem (call it the stochastic solution, SS) and the objective value for the deterministic problem computed by replacing stochastic variables by their expectations (call it the expected value solution, EVS):
V SS = SS − **EV S**. This computes the benefit of knowing the distributions of the stochastic variables. Clearly, VSS
is non-negative. We also compute the expected value of the wait-and-see solution (WSS). To calculate this, we give the stochastic variables values according to their probability distributions, and then find the best values for the decision variables. The difference between WSS and SS is the expected value of perfect information (EVPI): EV P I = **W SS** − SS.

This measures how much more you can expect to win if you have perfect information about the stochastic components of the problem. In other words, EVPI measures the value of knowing the future with certainty. This is therefore the most that should be spent in gathering information about the uncertain world.