
## 7 Scenario Reduction

One problem with a scenario-based approach is the large number of scenarios, each of which introduces new decision variables. We have therefore implemented several techniques to reduce the number of scenarios. The simplest is to consider just a single scenario in which stochastic variables take their expected values. This is supported with the command:
scenario expected; The user may also be content to consider just the most probable scenarios and ignore rare events. We support this with the command:
scenario top <Num>;
Another option is to use Monte Carlo sampling. The user can specify the number of scenarios to sample using a command of the form:
scenario sample <Num>;
The probability distributions of the stochastic variables is used to bias the construction of these scenarios.

We also implemented one of the best sampling methods from experimental design, and one of the best scenario reduction methods from operations research. Latin hypercube sampling [McKay *et al.*, 1979], ensures that a range of values for a variable are sampled. Suppose we want n sample scenarios. We divide the unit interval into n intervals, and sample a value for each stochastic variable whose cumulative probability occurs in each of these interval. We then construct n sample scenarios from these values, enforcing the condition that the samples use each value for each stochastic variable exactly once. More precisely, let fi(a) be the cumulative probability that Xi takes the value a or less, πi(j) be the jth element of a random permutation πi of the integers
{0**, . . . , n** − 1}, and r be a random number uniformly drawn from [0, 1]. Then, the jth Latin hypercube sample value for the stochastic variable Xi is:
f

## −1

i
(

## Πi(J) + R

n)
Finally, we implemented a scenario reduction method used in stochastic programming due to Dupacova, Growe-Kuska and Romisch [Dupacova *et al.*, 2002]. They report power production planning problems on which this method offers 90%
accuracy sampling 50% of the scenarios and 50% accuracy sampling just 2% of the scenarios. The method heuristically deletes scenarios to approximate as closely as possible the original scenarios according to a Fortet-Mourier metric on the stochastic parameter space.

## 8 Some Examples

To illustrate the potential of this framework for decision making under uncertainty, we now describe a wide range of problems that we have modelled. In the first problem, we compare a scenario-based approach to the previous tree search methods for solving stochastic constraint satisfaction problems. In the next three problems, we illustrate the effectiveness of the different scenario reduction techniques.

8.1 Production planning This problem comes from [Walsh, 2002]. The results in Table 1 show that a scenario-based approach offers much better performance on this problem than the forward checking or backtracking tree search algorithms also introduced in this paper.

The problem involves planning production over m quarters. In each quarter, we expect to sell between 100 and 105 copies of a book. To keep customers happy, we want to satisfy demand over all m quarters with 80% probability. This problem is modelled by an m stage stochastic CSP. There are m decision variables, xi representing production in each quarter. There are also m stochastic variables, yi representing demand in each quarter. To limit stock carried forward, we use a simple heuristic which picks the smallest possible values for the decision variables. An alternative is to convert the problem into an optimization problem with a cost to keep books in store. We do not explore this option here, though it is very easy to implement in stochastic OPL, as we cannot then compare our results with those of the forward checking or backtracking algorithms from [Walsh, 2002].

## 8.2 Portfolio Management

This portfolio management problem of
[Birge and Louveaux, 1997] can be modelled as a stochastic COP. Suppose we have $P to invest in any of I investments and we wish to exceed a wealth of $G after t investment periods. To calculate the utility, we suppose that exceeding
$G is equivalent to an income of q% of the excess while not meeting the goal is equivalent to borrowing at a cost r% of the amount short. This defines a concave utility function for r > q. The uncertainty in this problem is the rate of return, which is a random variable, on each investment in each period. The objective is to determine the optimal investment strategy, which maximizes the investor's expected utility.

The problem has 8 stages and 5760 scenarios. To compare the effectiveness of the different scenario reduction algorithms, we adopt a two step procedure. In the first step, the scenario reduced problem is solved and the first period's decision is observed. We then solve the full-size (non scenario reduced) problem to optimality with this first decision fixed.

The difference between the objective values of these two solutions is normalized by the range [optimal solution, observed worst solution] to give a normalized error for committing to the scenario reduced first decision. In Fig. 1, we see that Dupacova et al's algorithm is very effective, that Latin hypercube sampling is a small distance behind, and both are far ahead of the most likely scenario method (which requires approximately half the scenarios before the first decision is made correctly).

## 8.3 Yield Management

Farmers must deal with uncertainty since weather and many other factors affect crop yields. In this example (also taken from [Birge and Louveaux, 1997]), we must decide on how many acres of his fields to devote to various crops before the planting season. A certain amount of each crop is required for cattle feed, which can be purchased from a wholesaler if not raised on the farm. Any crop in excess of cattle feed can be sold up to the EU quota; any amount in excess of this quota