# Reasoning About Soft Constraints And Conditional Preferences: Complexity Results And Approximation Techniques∗

C. Domshlak Dept. of Computer Science Cornell University Ithaca, NY, USA
dcarmel@cs.cornell.edu F. Rossi and **K. B. Venable**
Dept. of Mathematics University of Padova Padova, Italy
{frossi,kvenable}@math.unipd.it T. Walsh Cork Constraint Computation Centre University College Cork Cork, Ireland tw@4c.ucc.ie

## Abstract

Many real life optimization problems contain both hard and soft constraints, as well as qualitative conditional preferences. However, there is no single formalism to specify all three kinds of information. We therefore propose a framework, based on both CP-nets and soft constraints, that handles both hard and soft constraints as well as conditional preferences efficiently and uniformly. We study the complexity of testing the consistency of preference statements, and show how soft constraints can faithfully approximate the semantics of conditional preference statements whilst improving the computational complexity.

## 1 Introduction And Motivation

Representing and reasoning about preferences is an area of increasing interest in theoretical and applied AI. In many real life problems, we have both hard and soft constraints, as well as qualitative conditional preferences. For example, in a product configuration problem, the producer may have hard and soft constraints, while the user has a set of conditional preferences. Until now, there has been no single formalism which allows all these different kinds of information to be specified efficiently and reasoned with effectively. For example, soft constraint solvers [Bistarelli *et al.*, 1997; Schiex *et al.*, 1995]
are most suited for reasoning about the hard and soft constraints, while CP-nets [Boutilier *et al.*, 1999] are most suited for representing qualitative conditional preference statements. In this paper, we exploit a connection between these two approaches, and define a framework based on both CPnets and soft constraints which can efficiently handle both constraints and preferences.

∗This research was partially funded by AFOSR, grant F4962001-1-0076 (Intelligent Information Systems Institute, Cornell University) and F49620-01-1-0361 (MURI grant on Cooperative Control of Distributed Autonomous Vehicles in Adversarial Environments), DARPA, F30602-00-2-0530 (Controlling Computational Cost: Structure, Phase Transitions and Randomization) and F3060200-2-0558 (Configuring Wireless Transmission and Decentralized Data Processing for Generic Sensor Networks), the Italian MIUR
projects NAPOLI and COVER, the ASI (Italian Space Agency)
project ARISCOM and Science Foundation Ireland.

Soft constraints[Bistarelli *et al.*, 1997; Schiex *et al.*, 1995]
are one of the main methods for dealing with preferences in constraint optimization. Each assignment to the variables of a constraint is annotated with a level of its desirability, and the desirability of a complete assignment is computed by a combination operator applied to the "local" preference values.

Whilst soft constraints are very expressive, and have a powerful computational machinery, they are not good at modeling and solving the sort of conditional preference statements that occur in the real world. Moreover, soft constraints are based on *quantitative* measures of preference, which tends to make preference elicitation more difficult.

Qualitative user preferences have been widely studied in decision-theoretic AI [Doyle and Thomason, 1999]. Of particular interest are CP-nets [Boutilier *et al.*, 1999]. These model statements of qualitative and conditional preference such as "I prefer a red dress to a yellow dress", or "If the car is convertible, I prefer a soft top to a hard top". These are interpreted under the *ceteris paribus* (that is, "all else being equal") assumption. Preference elicitation in such a framework is intuitive, independent of the problem constraints, and suitable for naive users. However, the Achilles heel of CP-nets and other sophisticated qualitative preference models[Lang, 2002] is the complexity of reasoning with them [Domshlak and Brafman, 2002; Boutilier *et al.*, 2002].

Motivated by a product configuration application [Sabin and Weigel, 1998], we have developed a framework to reason simultaneously about qualitative conditional preference statements and hard and soft constraints.

In product configuration, the producer has hard (e.g., component compatibility) and soft (e.g., supply time) constraints, while the customer has preferences over the product features. We first investigate the complexity of reasoning about qualitative preference statements, addressing in particular preferential consistency. To tackle the complexity of preference reasoning, we then introduce two approximation schemes based on soft constraints.

To the best of our knowledge, this work provides the first connection between the CP-nets and soft constraints machinery. In addition, for product configuration problems or any problem with both hard and soft quantitative constraints as well as qualitative conditional preferences, this framework lets us treat the three kinds of information in a unifying environment. Finally, we compare the two approximations in