
## 2 Formalisms For Describing Preferences 2.1 Soft Constraints

There are many formalisms for describing *soft constraints*.

We use the c-semi-ring formalism [Bistarelli *et al.*, 1997],
which is equivalent to the valued-CSP formalism when total orders are used [Bistarelli *et al.*, 1996], as this generalizes many of the others. In brief, a soft constraint associates each instantiation of its variables with a value from a partially ordered set. We also supply operations for combining (×) and comparing (+) values. A semi-ring is a tuple hA, +, ×, 0, 1i such that: A is a set and 0, 1 ∈ A; + is commutative, associative and 0 is its unit element; × is associative, distributes over +, 1 is its unit element and 0 is its absorbing element.

A *c-semi-ring* is a semi-ring hA, +, ×, 0, 1i in which + is idempotent, 1 is its absorbing element and × is commutative.

Let us consider the relation ≤ over A such that a ≤ b iff a + b = b. Then ≤ is a partial order, + and × are monotone on ≤, 0 is its minimum and 1 its maximum, hA, ≤i is a complete lattice and, for all a, b ∈ A, a + b = lub(**a, b**).

Moreover, if × is idempotent: + distributes over ×; hA, ≤i is a complete distributive lattice and × its glb. Informally, the relation ≤ compares semi-ring values and constraints. When a ≤ b, we say that *b is better than a*. Given a semi-ring S = hA, +, ×, 0, 1i, a finite set D (variable domains) and an ordered set of variables V , a *constraint* is a pair hdef **, con**i where con ⊆ V and def : D|con| → A. A constraint specifies a set of variables, and assigns to each tuple of values of these variables an element of the semi-ring.

A *soft constraint satisfaction problem* (SCSP)
is given by a set of soft constraints. For example, a classical CSP is an SCSP with the c-semiring SCSP = h{f alse, true}, ∨, ∧**, f alse, true**i, a fuzzy CSP [Schiex, 1992] is an SCSP with the csemi-ring SF CSP = h[0, 1]**, max, min,** 0, 1i, and probabilistic and weighted CSPs are SCSPs with the c-semi-rings Sprob = h[0, 1]**, max,** ×, 0, 1i and Sweight = hR**, min,** +, 0, +∞i, respectively. A solution to an SCSP is a complete assignment to its variables.

The preference value associated with a solution is obtained by multiplying the preference values of the projections of the solution to each constraint. One solution is better than another if its preference value is higher in the partial order.

Finding an optimal solution for an SCSP is an NP-complete problem. On the other hand, given two solutions, checking whether one is preferable is easy: we compute the semi-ring values of the two solutions and compare the resulting values.

## 2.2 Cp-Nets

Soft constraints are the main tool for representing and reasoning about preferences in constraint satisfaction problems.

However, they require the choice of a semi-ring value for each variable assignment in each constraint. They are therefore a quantitative method for expressing preferences. In many applications, it is more natural for users to express preferences via generic qualitative (usually partial) preference relations

![0_image_0.png](0_image_0.png)

## Figure 1: The Cp-Net Graph For The Example.

over variable assignments. For example, it is often more intuitive for the user to say "I prefer red wine to white wine",
rather than "Red wine has preference 0.7 and white wine has preference 0.4". Of course, the former statement provides less information, but it does not require careful selection of preference values to maintain consistency. Moreover, soft constraints do not naturally represent conditional preferences, as in "If they serve meat, then I prefer red wine to white wine". It is easy to see that both qualitative statements and conditions are essential ingredients in many applications.

CP-nets [Boutilier *et al.*, 1999] are a graphical model for compactly representing conditional and qualitative preference relations. They exploit conditional preferential independence by structuring a user's preferences under the ceteris paribus assumption. Informally, CP-nets are sets of *conditional ceteris paribus (CP)* preference statements. For instance, the statement "I prefer red wine to white wine if meat is served." asserts that, given two meals that differ *only* in the kind of wine served and both containing meat, the meal with a red wine is preferable to the meal with a white wine.

Many philosophers (see [Hansson, 2001] for an overview) and AI researchers [Doyle and Wellman, 1994], have argued that most of our preferences are of this type.

CP-nets bear some similarity to Bayesian networks, as both utilize directed acyclic graphs where each node stands for a domain variable, and assume a set of features F = {X1**, . . . , X**n} with finite, discrete domains D(X1)**, . . . ,** D(Xn) (these play the same role as variables in soft constraints). During preference elicitation, for each feature Xi, the user is asked to specify a set of *parent* features P a(Xi) that can affect her preferences over the values of Xi.

This information is used to create the graph of the CP-net in which each node Xi has P a(Xi) as its immediate predecessors. Given this structural information, the user is asked to explicitly specify her preference over the values of Xi for each complete assignment on P a(Xi), and this preference is assumed to take the form of total [Boutilier *et al.*, 1999] or partial [Boutilier *et al.*, 2002] order over D(X). These conditional preferences over the values of Xi are annotated with the node Xiin the CP-net. For example, consider a CP-net with the graph given in Figure 1, and with the preference statements as follows: a ≻ a, b ≻ b, (a ∧ b) ∨ (a ∧ b) : c ≻ c,
(a∧b)∨(a∧b) : c ≻ c, c : d ≻ d, c : d ≻ d. Here, statement a ≻ a represents the unconditional preference of the user for A = a over A = a, while statement c : d ≻ d represents that the user prefers D = d to D = d, given that C = c.

Several types of queries can be asked about CP-nets.

First, given a CP-net N, one might be interested in finding an optimal assignment to the features of N. For acyclic CP-nets, such a query is answerable in linear time [Boutilier *et al.*, 1999]. Second, given a CP-net N and a pair of complete assignments α and β, one might be inter-