3 Motivating applications
3.1 Matrix symmetry
Many constraints programs contain matrices of decision variables (so called "matrix models"), and the rows and/or
columns of these matrices are symmetric and can be permuted [Flener *et al.*, 2002]. Such symmetries are very difficult to deal with as there are a super-exponential number
of permutations of the rows or columns to consider. There are several ways to break symmetry in a CSP, such as SBDS
[Gent and Smith, 2000] or SBDD [Fahle *et al.*, 2001]. One
of the most effective, and the one which we will concentrate on as a major application for a multiset ordering constraint,
is adding extra symmetry-breaking constraints to an initial
model. Existing techniques for dealing with such symmetries
typically eliminate only some of the symmetry. Additional
techniques, like those proposed here, are therefore of considerable value.
The progressive party problem mentioned earlier has a 2d
matrix of decision variables with matrix symmetry. The rows of the matrix are the guests, the columns are the periods. Each
variable gives the host assigned to a given guest in a given period. As periods are indistinguishable, the columns of the matrix are symmetric. One way to break such column symmetry
is to lex order the columns [Frisch *et al.*, 2002]. Similarly, as
guests can be indistinguishable, (some of) the rows may be
symmetric and can be lex ordered. Alternatively, we can treat
each row and/or column as a multiset and break such symmetry by multiset ordering the rows and/or columns.
Unlike lex ordering, multiset ordering the rows of a matrix
may not eliminate all row symmetry. For example, consider the symmetric matrices:
0 0
0 1   0 0
$\begin{array}{ccc}'&0&0\\ &1&0\\ \end{array}$ 3. 
Both satisfy the constraint that the first row is multiset less
than the second. It is therefore a little surprising to discover that multiset ordering (which does not break all row
symmetry) is not dominated by lex ordering (which does)
but is incomparable. For example, h0, 2i ≤lex h1, 1i but h1, 1i ≤m h0, 2i.
When we have both row and column symmetry, we can
multiset order both rows and columns. Like lex ordering both
rows and columns, this may not eliminate all row and column
symmetry. Consider the symmetric matrices:
**0 1 1**
1 0 1   **1 0 1**
0 1 1 
Both have multiset ordered rows and columns. Unsurprisingly, multiset ordering rows and columns is incomparable
to lex ordering rows and columns. Consider the symmetric
matrices:
 **0 0 1**
0 1 0
1 1 0   **0 1 0**
1 0 1 
The first has lex ordered rows and columns, but the columns
are not multiset ordered. The second has rows and columns that are multiset ordered but the columns are not lex ordered.
An alternative way to deal with row and column symmetry
is to multiset order in one dimension and apply the symmetry breaking method of our choice in the other dimension.
This is one of the best features of using multiset ordering
$\begin{array}{ccc}1\\ 0\\ 0\end{array}\end{array}$ $\left(\begin{array}{cc}0&1\\ 0&0\\ 1&0\end{array}\right)$
to break symmetry. It is compatible with any other method
in the other dimension. For instance, we can multiset order the rows and lex order the columns. Preliminary results
in [Kiziltan and Smith, 2002] suggest that such a combined
method is very promising. This combined method does not eliminate all symmetry (but it is unlikely that any polynomial
set of constraints does). Consider the symmetric matrices:
 **0 1 1**
1 0 1
$\begin{array}{ccc}1&1\\ 0&1\\ 2&0\end{array}\end{array}$$\left(\begin{array}{ccc}0&1&1\\ 1&0&1\\ 2&1&0\end{array}\right)$  - I'm not sure I'm not sure. 
Both have rows that are multiset ordered, and rows and
columns that are lex ordered. Multiset ordering the rows and
lex ordering the columns is again incomparable to lex ordering rows and columns. Consider the symmetric matrices:
0 0 1 0 1 0 1 0 0 1 2 0
0 2 2
$\left(\begin{array}{c}0\\ 0\\ 1\\ 1\\ 0\end{array}\right)$
$$\begin{array}{l l l}{{0}}&{{1}}\\ {{1}}&{{0}}\\ {{0}}&{{0}}\\ {{2}}&{{0}}\\ {{2}}&{{2}}\end{array}\right)\qquad\left(\begin{array}{l l l}{{0}}&{{0}}&{{1}}\\ {{0}}&{{1}}&{{0}}\\ {{0}}&{{2}}&{{2}}\\ {{1}}&{{0}}&{{0}}\\ {{1}}&{{0}}&{{2}}\end{array}\right)$$
$\frac{1}{1}$  1. 
$\square$
The first matrix has rows that are multiset ordered and columns that are lex ordered. However, its rows are not lex ordered. The second matrix has rows and columns that are lex ordered but does not have rows that are multiset ordered. Whilst the two orderings are theoretically incomparable, our experimental results (see later) show that multiset ordering the rows and lex ordering the columns is often the most effective symmetry breaking constraint currently known.

## 3.2 Fuzzy Constraints

$\begin{array}{c}0\\ 1\end{array}$ ). 
$$\mathbf{\Pi}_{0}^{0}$$
$\downarrow$ . 
Another application for multiset ordering is to fuzzy CSPs. A
fuzzy constraint associates a degree of satisfaction to an assignment tuple for the variables it constrains. To combine degrees of satisfaction, we can use a combination operator like the minimum function. Unfortunately, the minimum function may cause a *drowning effect* when one poorly satisfied constraint 'drowns' many highly satisfied constraints. One solution is to collect a vector of degrees of satisfaction, sort these values in ascending order and compare them lexicographically. This *leximin* combination operator identifies the assignment that violates the fewest constraints [Fargier, 1994].

This induces an ordering identical to the multiset ordering except that the lower elements of the satisfaction scale are the more significant. It is simple to modify a multiset ordering constraint to consider the values in a reverse order. To solve such leximin fuzzy CSPs, we can then use branch and bound, adding an ordering constraint when we find a solution to ensure that future solutions are greater in the leximin ordering.

$${\begin{array}{l l}{{\bar{0}}}&{{\bar{1}}}\end{array}}$$

## 4 Gac Algorithm For Multiset Ordering

$\square$
 $\mathbf{1}$
The last section motivated why we want multiset ordering constraints. We need, however, to be able to propagate such constraints efficiently. We therefore developed an efficient GAC algorithm for such constraints.

## 4.1 Background

The algorithm exploits two theoretical results. The first reduces the problem to testing support for upper bounds of ~x and lower bounds of ~y on suitable ground vectors. The second reduces these tests to lex ordering suitable occurrence