Olston and Chi (2003) deal with browsing and/or search, based on unstructured text and hypertext. Instead, in this work, we deal with semi-structured textual data - filmscripts. Other than the immediate benefits relating to the early stages of movie or television program creation, there is great potention in our work for all areas that use semi-structured textual segments (e.g. in medical doctor-patient interactions, or for business or other interviews).

Since the mid-1990s we built visual interactive maps of bibliographic and database information at Strasbourg Astronomical Observatory, and some of these, with references, are available at Murtagh (2006). A comprehensive view of the Kohonen self-organizing feature map used can be found at websom.hut.fi
(Kohonen et al. 2000).

A more recent development has been tag clouds. McKie (2007) discusses examples and provides an online system for creating of filmscript term "clouds".

He discusses similar tools (e.g., TagCrowd, www.tagcrowd.com; Zoomcloud, zoomclouds.egrupos.net). Similar tag clouds are commonly used to present information in large data repositories (e.g. flickr, www.flickr.org).

The motivation for such tools is to have (possibly interactive) annotated maps to support information navigation. Prominent terms are graphically presented and can be used to carry out a local search. In some cases, the location of terms is important, in particular in the case of the Kohonen map. The *automated* annotation of such information maps is not easy. Often the basis for display font size and sometimes even for location on the maps is simply frequency of term occurrence. The work presented in this article aims at taking more available information into account, leveraging interrelationships in textual content and thereby semantic content.

Our concern is not with overly large visualizations (see Kaser and Lemire, 2007, who use an optimal display layout algorithm) but rather with (i) structure in the form of sequence, and (ii) taking context and thereby semantics into account.

## 1.2 Filmscript

A filmscript, expressing a story, is the starting point for any possible production for cinema or TV. TV episodes in the same series may each be developed by different scriptwriters, and later by different producers and directors. The aim of any TV screenplay is to provide a unique but repeatable experience in which each episode shares certain structural and narrative traits with other episodes from the same series despite the fact they may have originated or been realised by different people or teams. There is a productive tension between the separate needs for uniqueness, - that each episode seems fresh and surprising, and belonging to its genre. An episode of any series needs to have a common feel, to offer the specific kinds of pleasure the audience associates with the series.

We believe that these distinctive qualities of any individual script and the distinctive qualities of any genre could be subject to analysis through a tool which finds distinctive ways of representing the essential structural qualities of any script, and the series to which it belongs and thus enables the writer, the script