# A Logic Programming Approach To Activity Recognition

Alexander Artikis1, Marek Sergot2 **and Georgios Paliouras**1 1
**Institute of Informatics & Telecommunications,**
NCSR Demokritos, Athens 15310, Greece 2**Department of Computing, Imperial College London, SW7 2BT, UK**
{a.artikis, paliourg}@iit.demokritos.gr, mjs@doc.ic.ac.uk

## Abstract

We have been developing a system for recognising human activity given a symbolic representation of video content. The input of our system is a **set of time-stamped**
short-term activities detected on video frames. The output **of our system is a set of**
recognised long-term activities, which are pre-defined temporal combinations of shortterm activities. The constraints on the short-term activities that, if satisfied, lead to the recognition of a long-term activity, are expressed using a dialect of the Event Calculus.

We illustrate the expressiveness of the dialect by showing the representation of several typical complex activities. Furthermore, we present a detailed evaluation of the system through experimentation on a benchmark dataset of surveillance videos.

## 1 Introduction

A common approach to human activity recognition separates low-level from high-level recognition. The output of the former type of recognition is a set of activities taking place in a short period of time: 'short-term activities'. The output of the latter type of recognition is a set of 'long-term activities', ie pre-defined temporal combinations **of short-term activities.** We focus on high-level recognition.

We define a set of long-term activities of interest, such as 'fighting' **and 'meeting', as**
temporal combinations of short-term activities - eg, 'walking', 'running', and 'inactive' (standing still) - using a logic programming implementation of the Event **Calculus [9].**
More precisely, we employ the Event Calculus to express the temporal constraints on a set of short-term activities that, if satisfied, lead to the recognition of a long-term activity.

We presented preliminary results on activity recognition from video content in [2]. (In
[3] we described some initial steps towards automatically constructing activity definitions using machine learning techniques - the use of such techniques is out **of the scope of this** paper.) In this paper we extend our previous work in the following ways. First, we use a more efficient Event Calculus dialect and implementation to compute the intervals of longterm activities. Second, we illustrate the expressiveness of the proposed Event Calculus dialect by presenting several complex activity definitions. We are able to construct much more succinct representations of activity definitions for video surveillance than we had in our earlier work. Third, we present a more detailed and informative evaluation of the Event Calculus on activity recognition. We show through experimentation how incomplete shortterm activity narratives, inconsistent annotation of short-term **and long-term activities,**
and a limited dictionary of short-term activities and context variables affect recognition