
## 6 Discussion

Numerous recognition systems have been proposed in the literature. In this section we focus on long-term activity (high-level) recognition systems that, similar to our approach, exhibit a formal, declarative semantics.

A well-known system for activity recognition is the Chronicle Recognition System (CRS)2.

A 'chronicle' can be seen as a long-term activity - it is expressed in terms of a set of events (short-term activities in our example), linked together by time constraints, and, possibly, a set of context constraints. The language of CRS relies on a reified temporal logic, where propositional terms are related to time-points or other propositional terms. Time is considered as a linearly ordered discrete set of instants. The language **includes predicates for**
persistence and event absence. Details about CRS may be found on **the web page of the**
system and [5].

The CRS language does not allow mathematical operators in the constraints of atemporal variables. Consequently, the computation of the distance between two people/objects cannot be computed. CRS, therefore, cannot be directly used for activity recognition in video surveillance applications. More generally, CRS cannot be directly used for activity recognition in applications requiring any form of spatial reasoning, or any other type of atemporal reasoning. These limitations could be overcome by developing a separate tool for atemporal reasoning that would be used by CRS whenever this form **of reasoning was required. To the best of our knowledge, such extensions of CRS are not available. Clearly, the**
computational efficiency of CRS, which is one of the main advantages **of using this system** for activity recognition, would be compromised by the integration of **an atemporal reasoner.**
Hakeem and Shah [7] have presented a hierarchical event representation for analysing videos. The temporal relations between the sub-events of an event definition (or activity, in the terminology of this paper) are represented using the interval algebra of [1] and an extended form of the CASE representation [6] originally used for the syntactic analysis of natural languages.

In our approach to activity recognition, the availability of the full power of logic programming is one of the main attractions of employing the Event Calculus as the temporal formalism. It allows activity definitions to include not only complex temporal constraints —
LTAR-EC is at least as expressive as the CRS language and the extended CASE representation with respect to temporal representation - but also complex **atemporal constraints.**
Moreover, when necessary more expressive Event Calculus dialects may be adopted (see, eg, [10]).

Shet et al. have presented a logic programming approach to activity **recognition. See**
[12, 13] for two recent publications. These researchers have presented activity definitions concerning theft, entry violation, unattended packages, and so **on. A distinguishing feature** of our approach with respect to this line of work concerns the fact **that we use the Event** Calculus for temporal representation and reasoning. The temporal aspects of the definitions of Shet, Davis et al. are crudely represented - eg, there are no rules for computing the intervals in which a long-term activity takes place. In contrast, the **Event Calculus has** built-in axioms for complex temporal representation, including the formalisation of inertia, durative events, events with delayed effects, etc, which help considerably the system designer develop activity definitions. Shet and colleagues stated that "[i]n the **future we would like** to extend this system to reason explicitly about temporal information thus helping us [..] to define models for and recognise human activities within a single framework" [13, p.8]. To the best of our knowledge, they have not developed a system for explicit temporal representation and reasoning since.

2http://crs.elibel.tm.fr/