Shet and colleagues have incorporated in their logic programming framework a mechanism for reasoning over rules and facts that have an uncertainty value attached. We aim to extend our work by allowing for uncertainty values in the rules of activity definitions in order to address, to a certain extent, the issues arising from incomplete short-term activity narratives, inconsistent annotation of short-term and long-term activities, and a limited dictionary of short-term activities and context variables.

Paschke and colleagues [11] have also proposed the use of an Event **Calculus dialect**
for event recognition. This dialect and LTAR-EC have numerous differences. For example, unlike LTAR-EC, there is no support in the dialect of Paschke et al for multi-valued fluents - only Boolean fluents are considered. Moreover, the treatment of **intervals is quite different.** The Event Calculus dialect of Paschke and colleagues, for instance, **does not include axioms**
for recognising an 'on-going' long-term activity, ie a activity that started taking place at some earlier time-point and still holds. There are also very significant **differences in the**
implementations.

Apart from the numerous differences in expressiveness and implementation, a key contribution of the work presented here, as we see it, is that we have illustrated the expressiveness of the Event Calculus for complex activity recognition on a benchmark example, showed a range of different types of definition, and evaluated the adequacy of our representation empirically. We expect that the example itself will be a valuable resource in future uses of the Event Calculus for activity/event recognition.

A logic programming approach to activity recognition has, among others, the advantage that machine learning techniques can be directly employed for developing/refining activity definitions. An area of current work is the use of abductive and inductive logic programming techniques for learning activity definitions. Details about this line of work are given in [3].

LTAR-EC does not currently store the outcome of query computation, ie the intervals of the recognised activities. Consequently, LTAR-EC often performs unnecessary computations, re-computing activity intervals that it already computed but **did not store. We are**
currently experimenting to find the most effective options for caching in LTAR-EC, including those presented in [4].

## Acknowledgements

This work was supported partly by the EU PRONTO Project (FP7-ICT 231738).

## References

[1] J. Allen and G. Ferguson. Actions and events in interval temporal logic. **Journal of**
Logic and Computation**, 4(5):531–579, 1994.**

[2] A. Artikis and G. Paliouras. Behaviour recognition using the event calculus. In **Artificial**
Intelligence Applications & Innovations**. Springer, 2009.**
[3] A. Artikis, A. Skarlatidis, and G. Paliouras. Behaviour recognition **from video content**
using the event calculus. International Journal of AI Tools**, 19(2), 2010.**

[4] L. Chittaro and A. Montanari. Efficient temporal reasoning in the **cached event calculus.**
Computational Intelligence**, 12(3):359–382, 1996.**
[5] C. Dousson and P. Le Maigat. Chronicle recognition improvement using temporal focusing and hierarchisation. In IJCAI**, pages 324–329, 2007.**