
| Table 1: Main Predicates of the LTAR-EC.                                         |                                                                       |
|----------------------------------------------------------------------------------|-----------------------------------------------------------------------|
| Predicate                                                                        | Meaning                                                               |
| happensAt(E, T )                                                                 | Event E is occurring at time T                                        |
| happensFor(E, I)                                                                 | I is the list of maximal intervals during which event E takes place   |
| initially(F = V )                                                                | The value of fluent F is V at time 0                                  |
| holdsAt(F = V, T )                                                               | The value of fluent F is V at T                                       |
| holdsFor(F = V, I)                                                               | I is the list of maximal intervals for which F = V holds continuously |
| initiatedAt(F = V, T )                                                           | At time T a period of time for which F = V is initiated               |
| terminatedAt(F = V, T ) At time T a period of time for which F = V is terminated |                                                                       |

accuracy. Fourth, we evaluate our approach on a dataset with a refined dictionary of shortterm activities, in order to validate experimentally our intuition that a **finer classification**
of short-term activities increases, under certain circumstances, the accuracy of long-term activity recognition. Indeed, the refined dictionary of short-term activities - which can be provided by state-of-the-art short-term activity recognition systems - together with the updated long-term activity definitions presented in this paper, lead **to much higher Precision** and Recall rates.

The remainder of the paper is organised as follows. First, we present the Event Calculus dialect that we employ to formalise activity definitions. Second, we describe the dataset of short-term activities on which we perform long-term activity recognition. Third, we present our knowledge base of long-term activity definitions. Fourth, we present our experimental results. Finally, we discuss related work and outline directions for further research.

## 2 The Event Calculus

Our long-term activity recognition (LTAR) system consists of a logic **programming (Prolog)** implementation of an Event Calculus dialect. The Event Calculus, introduced by Kowalski and Sergot [9], is a many-sorted, first-order predicate calculus for representing and reasoning about events and their effects. For the dialect used here, hereafter LTAR-EC (event calculus for long-term activity recognition), the time model is linear and it may **include real numbers**
or integers. Where F is a fluent **— a property that is allowed to have different values at** different points in time - the term F = V denotes that fluent F has value V **. Boolean** fluents are a special case in which the possible values are true and false**. Informally,** F = V holds at a particular time-point if F = V has been initiated **by an event at some earlier**
time-point, and not terminated **by another event in the meantime.**
An event description **in LTAR-EC includes axioms that define, among other things, the**
event occurrences (with the use of the happensAt and happensFor **predicates), the effects of**
events (with the use of the initiatedAt and terminatedAt **predicates), and the values of the** fluents (with the use of the initially, holdsAt and holdsFor **predicates). Table 1 summarises** the main predicates of LTAR-EC. Variables, starting with an upper-case letter, are assumed to be universally quantified unless otherwise indicated. Predicates, **function symbols and** constants start with a lower-case letter.

The domain-independent axioms for holdsAt and holdsFor **are such that, for any fluent** F,
holdsAt(F = V, T ) if and only if time-point T **belongs to one of the maximal intervals of** I such that holdsFor(F = V, I**). However, for efficiency the implementation employs different**