procedures for these two tasks, and various indexing techniques **to reduce search and improve**
efficiency further. Briefly, to compute holdsFor(F = V, I), we find all time-points Ti**in which** F = V is initiated, and then, for each Ti, we compute the first time-point after Ti**in which**
F = V **is terminated. If the list of initiating time-points is generated in sorted order, which**
is easy to arrange, both steps can make effective use of indexing. In particular, if the list of initiating time-points contains an adjacent pair . . . , Ti, Ti+1, . . . then the terminating timepoint corresponding to Ti must occur between Ti and Ti+1**. In outline, the indexing works**
as follows.

The domain-independent axioms for holdsAt **can be written in the following form:**

holdsAt($F=V,\ T$) $\leftarrow$  initiatedAt($F=V,\ T_{s}$), not broken($F=V,\ T_{s},\ T$)  broken($F=V,\ T_{s},\ T$) $\leftarrow$  terminatedAt($F=V,\ T_{f}$), $\ T_{s}<T_{f}<T$  broken($F=V_{1},\ T_{s},\ T$) $\leftarrow$  initiatedAt($F=V_{2},\ T_{f}$), $\ V_{1}\neq V_{2},\ T_{s}<T_{f}<T$
$$(1)$$
$$\mathbf{\Sigma}(2)$$
$\left(3\right)$. 
not **in rule (1) represents 'negation by failure', which provides a form of default persistence** ('inertia') of fluents.

According to rule (2), a period of time for which F = V **holds is** broken at Tf if F = V
is terminated at time Tf . According to rule (3), if F = V2 is initiated at Tf **then effectively**
F = V1 is terminated at time Tf , for all other possible values V1 of F**. Rule (3) ensures**
therefore that a fluent cannot have more than one value at any time.

Besides the general, domain-independent rule initiatedAt(F = V, 0) ← initially(F = V **), the**
definitions of initiatedAt and terminatedAt **are domain specific. One common form of rule for** initiatedAt**, eg, has the general form:**

$$\begin{array}{l}\mbox{initial}\mbox{At}(F=V,\ T)\leftarrow\\ \mbox{happensAt}(Ev,\ T),\ \mbox{\it Conditions}[T]\end{array}$$
$\left(4\right)$. 
where Conditions [T ] is some set of further conditions referring to time T **. Concrete examples**
of initiatedAt **rules are provided in the section that follows.**
To explain what we mean by indexing, note that clauses (1), (2) and (3) can be written equivalently as follows: when every rule of the form (4) is transformed into the form:

$$\begin{array}{c}{{\mathrm{initiatedAt}(F=V,\ T_{m i n},\ T,\ T_{m a x})\leftarrow}}\\ {{\mathrm{happensAt}(E v,\ T_{m i n},\ T,\ T_{m a x}),\ \,C o n d i t i o n s[T]}}\end{array}$$
happensAt(Ev, Tmin, T, Tmax), Conditions[T ](8)
The extra arguments in initiatedAt, terminatedAt**, and** happensAt specify the range of timepoints Tmin and Tmax between which the time-point T **of interest must occur. Thus**
happensAt(Ev, Tmin, T, Tmax**) iff** happensAt(Ev, T ) and Tmin < T < Tmax.

holdsAt$(F=V,\ T)\leftarrow$  initiatedAt$(F=V,\ 0,\ T_{s},\ T),\ \texttt{not broken}(F=V,\ T_{s},\ T)$  broken$(F=V,\ T_{min},\ T_{max})\leftarrow$  terminatedAt$(F=V,\ T_{min},\ T_{f},\ T_{max})$  broken$(F=V,\ T_{min},\ T_{max})\leftarrow$  initiatedAt$(F=V_{2},\ T_{min},\ T_{f},\ T_{max}),\ V_{1}\neq V_{2}$
$$\left(5\right)$$
$$({\mathfrak{h}})$$
$$\left(7\right)$$
$\left(\mathfrak{S}\right)$. 