Our implementation automatically transforms initiatedAt **rules of the form (4) into the**
form (8) on compilation, in a process transparent to the user. The **advantage is that in**
Prolog execution of holdsAt and holdsFor**, when** happensAt(Ev, Tmin, T, Tmax**) is called,** Ev is always ground (variable-free), which exploits Prolog's built-in indexing when searching for occurrences of event Ev. But much more importantly, Tmin and Tmax **are also always**
ground which means that the storage of happensAt **data can be indexed to exploit this and** reduce search very significantly.

terminatedAt **and other forms of** initiatedAt **rules are handled similarly. We omit these and**
other details for lack of space. The complete code for LTAR-EC is available upon request.

3 Short-Term Activities Our long-term activity recognition system (LTAR) includes long-term activity definitions in LTAR-EC. The input to LTAR is a symbolic representation of short-term activities. The output of LTAR is a set of recognised long-term activities. In [2, 3] we used the first dataset of the CAVIAR project1**to perform long-term activity recognition. This dataset includes 28**
surveillance videos of a public space. The videos are staged - actors **walk around, sit down,** meet one another, leave objects behind, fight, and so on. Each video has been manually annotated in order to provide the ground truth for both short-term and long-term activities.

Our preliminary experiments with this dataset, however, showed that the limited dictionary of short-term activity types compromised the recognition of **some long-term activities**
- it was often impossible to distinguish between certain long-term activities. To overcome this problem, in the context of this paper we introduced in the CAVIAR dataset a short-term activity for 'abrupt motion': we manually edited the annotation of the **CAVIAR videos by** changing, when necessary, the label of a short-term activity to 'abrupt motion'. This is a form of short-term activity that is recognised by some state-of-the-art recognition systems, such as [8]. A person is said to exhibit an 'abrupt motion' activity if he moves abruptly and his position in the global coordinate system does not change significantly - if it did then the short-term activity would be classified as 'running'. For this **set of experiments,** therefore, the input to LTAR is:
(i) The short-term activities abrupt motion, walking, running, active (non-abrupt body movement in the same position) and inactive (standing still), together with their timestamps, ie the video frame in which that short-term activity took place. These activities are mutually exclusive. This type of input is represented by means of the happensAt predicate - eg, happensAt(abrupt(id6 ), 15560) expresses that id6 **moved abruptly at**
video frame (time-point) 15560 **. Short-term activities are represented as events in the**
Event Calculus in order to use the initiatedAt and terminatedAt **predicates for expressing** the conditions in which these activities initiate and terminate a long-term activity.

(ii) The coordinates of the tracked people and objects as pixel positions at each timepoint. The coordinates are represented with the use of the holdsAt **predicate - eg,**
holdsAt(coord(id2 ) =(14, 55), 10600) expresses that the coordinates of id2 **are (**14, 55) at time-point (frame number) **10600** .

(iii) The first and the last time a person or object is tracked ('appears'/'disappears'). This type of input is represented using the happensAt **predicate. Eg,**
happensAt(appear (id10 ), 300) expresses that id10 **is first tracked at time-point (frame**
number) 300 .

Given this input, LTAR recognises the following long-term activities: a **person leaving**
an object, a person being immobile, people meeting, moving together, or fighting. Long-1**http://groups.inf.ed.ac.uk/vision/CAVIAR/CAVIARDATA1/**