interaction phase can be seen as some form of greeting (eg, a handshake). The rule below shows one set of conditions in which meeting **is initiated:**

$$\begin{array}{l}{{\mathrm{titatedAt}(\,m e e t i n g(P_{1}\,,\,\,P_{2})=\mathrm{true},\,\,\,T)\leftarrow}}\\ {{\mathrm{holdsAt}(\,c l o s e(P_{1}\,,\,\,P_{2}\,,\,\,25)=\mathrm{true},\,\,\,T),}}\\ {{\mathrm{holdsAt}(\,p e r s o n(P_{1}),\,\,\,T),}}\\ {{\mathrm{happensAt}(\,i n a c t i v e(P_{1}),\,\,\,T),}}\\ {{\mathrm{holdsAt}(\,p e r s o n(P_{2}),\,\,\,T),}}\\ {{\mathrm{not\,\,\,happensAt}(\,r u n i n g(P_{2}),\,\,\,T),}}\\ {{\mathrm{not\,\,\,happensAt}(\,a b r u p t(P_{2}),\,\,\,T)}}\end{array}$$
7
$$(12)$$

meeting is terminated when the two people walk away from each other, or one **of them**
starts running, moves abruptly, or 'disappears'. The formalisation **is straightforward and so** omitted here.

The activity moving **was defined in order to recognise whether two people are walking**
along together. This activity, like the activities presented so far, could be formalised in terms of initiatedAt/terminatedAt predicates to specify the conditions in which moving **starts/ceases**
to be recognised, and then using the domain-independent axioms of holdsFor **to compute the**
maximal intervals of this activity: moving **is initiated when two people are walking and are**
'close' to each other, and terminated when the people walk away from each other, when they stop moving, ie become active or inactive, when one of them starts running, moves abruptly, or 'disappears'.

A considerably more concise representation of moving**, however, can be given directly in**
terms of holdsFor:

holdsFor($moving(P_{1},P_{2})=$true, $MovingI)\leftarrow$ holdsFor($close(P_{1},P_{2},34)=$true, $CloseI)$, happensFor($walking(P_{1})$, $WalkingI_{1})$, happensFor($walking(P_{2})$, $WalkingI_{2})$, intersect_all([ _WalkingI_{1}, _WalkingI_{2}, _CloseI_], _MovingI_{1})\)
$$(13)$$
CloseI are the maximal intervals in which the distance between P1 and P2 **is continuously**
at most 34 **pixel positions. We compute these intervals using the recorded trajectories of** P1 and P2 **given as input to LTAR.** intersect all **computes the intersection of a list of intervals.**
The implementation of intersect all **and other constructs manipulating intervals is available**
with the source code of LTAR-EC. According to axiom (13), the maximal intervals in which P1 and P2 are moving **together are produced by the intersection of the intervals in which** P1 is 'close' to P2, P1 is walking and P2 **is walking.**
As in the case of moving, we could also have formalised leaving object, immobile and meeting **directly in terms of** holdsFor **(as opposed to representing these activities in terms**
of initiatedAt and terminatedAt **and then using the domain-independent axioms of** holdsFor to compute their maximal intervals). However, formalising leaving object, immobile and meeting **directly in terms of** holdsFor **is not more concise than formalising these activities in**
terms of initiatedAt and terminatedAt. For leaving object, immobile and meeting **it is much**
simpler to identify the conditions in which these activities are initiated and terminated, than identifying all possible conditions in which these activities hold.