The last definition of LTAR's knowledge base concerns the fighting **activity:**

$$\begin{array}{l}{{\mathrm{holdsFor}(f i g h t i n g(P_{1},P_{2})=\mathrm{true},\ F i g h t i n g I)\leftarrow}}\\ {{\mathrm{happensFor}(a b r u p t u p t I),\ A b r u p t I),}}\\ {{\mathrm{holdsFor}(c l o s e(P_{1},P_{2},24)=\mathrm{true},\ C l o s e I),}}\\ {{\mathrm{intersect\_all}([A b r u p t I,\ C l o s e I],\ A b r u p t C l o s e I)}}\\ {{\mathrm{happensFor}(i n a c t i n e v e(P_{2}),\ I n a c t i v e I),}}\\ {{\mathrm{complement}(A b r u p t C l o s e I,\ I n a c t i v e I I,\ F i g h t i n g I))}}\end{array}$$
$$(14)$$

complement **is an implementation of the complement operation. Two people are assumed to**
be fighting **if at least one of them is moving abruptly, the other is not inactive, and the** distance between them is at most 24 pixel positions. As in the case of moving**, we expressed**
the definition of fighting **directly in terms of** holdsFor **because expressing the conditions in**
which two people are fighting leads to a more succinct representation than expressing the conditions in which fighting **is initiated and terminated.**

## 5 Experimental Results

We present experimental results on 28 surveillance videos of the CAVIAR project. These videos contain 26419 frames that were manually annotated by the CAVIAR team in order to provide the ground truth for short-term and long-term activities. We edited the original CAVIAR annotation by introducing a short-term activity for abrupt motion. Table 2 shows the performance of LTAR; it shows, for each long-term activity, the number of True Positives (TP), False Positives (FP) and False Negatives (FN), and the corresponding Recall and Precision values. Long-term activities are recognised with the use of the holdsFor **Event** Calculus predicate.

LTAR achieved high Recall and Precision rates, indicating that it may adequately represent complex activities. Perfect Recall and Precision rates were not achieved due to various reasons. One of these reasons concerns the fact that the narrative of short-term activities (produced by manual annotation, in the present experiments) is incomplete. Eg, the single FN concerning leaving object **is due to the fact that in the video in question the object was**
left behind a chair and was not tracked. In other words, the left object never 'appeared', it never exhibited a short-term activity.

Another reason for having FP and FN is the lack of consistency in the **annotation of**
the videos; eg, the long-term activity of people walking in the same direction while being
'close' to each other is not always classified as moving **(this type of inconsistency leads to**
FP concerning the recognition of moving**), the short-term activity of people being active is** sometimes classified as walking (eg, leading to FN in the recognition of meeting**), and so on.**
The most important reason for not achieving perfect Recall and Precision in the CAVIAR
dataset concerns the limited dictionary of short-term activities and context variables with which the tracked activity is represented. The recognition of immobile**, for instance, would**
be much more accurate if there were a short-term activity for the **motion of leaning towards**
the floor or a chair. In the absence of such an activity, the recognition of **immobile** is primarily based on how long a person is inactive. In the CAVIAR videos a **person who falls**
on the floor or rests in a chair stays inactive for at least 54 **frames. Consequently LTAR** recognises immobile if, among other things, a person stays inactive for at least 54 **frames.**
There are situations, however, in which a person stays inactive for more than 54 **frames and**
has not fallen on the floor or sat in a chair: people watching a fight, or **just staying inactive**
waiting for someone. It is in those situations that we have the FP concerning **immobile**.

For similar reasons we did not achieve perfect Recall and Precision in the recognition of meeting; it is impossible to define this activity precisely due to the absence of a **short-term**