# Semi-Myopic Sensing Plans For Value Optimization

## David Tolpin

Computer Science Dept.

Ben-Gurion University 84105 Beer-Sheva, Israel

## Abstract

We consider the following sequential decision problem. Given a set of items of unknown utility, we need to select one of as high a utility as possible ("the selection problem").

Measurements (possibly noisy) of item values prior to selection are allowed, at a known cost. The goal is to optimize the overall sequential decision process of measurements and selection.

Value of information (VOI) is a well-known scheme for selecting measurements, but the intractability of the problem typically leads to using myopic VOI estimates. In the selection problem, myopic VOI frequently badly underestimates the value of information, leading to inferior sensing plans. We relax the strict myopic assumption into a scheme we term semi-myopic, providing a spectrum of methods that can improve the performance of sensing plans. In particular, we propose the efficiently computable method of "blinkered" VOI, and examine theoretical bounds for special cases. Empirical evaluation of "blinkered" VOI in the selection problem with normally distributed item values shows that is performs much better than pure myopic VOI.

## 1 Introduction

Decision-making under uncertainty is a domain with numerous important applications. Since these problems are intractable in general, special cases are of interest. In this paper, we examine the selection problem: given a set of items of unknown utility (but a distribution of which is known), we need to select an item with as high a utility as possible. Measurements
(possibly noisy) of item values prior to selection are

## Solomon Eyal Shimony

Computer Science Dept.

Ben-Gurion University 84105 Beer-Sheva, Israel allowed, at a known cost. The problem is to optimize the overall decision process of measurement and selection. Even with the severe restrictions imposed by the above setting, this decision problem is intractable [8]; and yet it is important to be able to solve, at least approximately, as it has several potential applications, such as sensor network planning, and oil exploration. Other settings where this problem is applicable are in considering which time-consuming deliberation steps to perform (meta-reasoning [9]) before selecting an action, locating a point of high temperature using a limited number of measurements (with dependencies between locations as in [5]), and the problem of finding a good set of parameters for setting up an industrial imaging system. The latter is actually the original motivation for this research, and is briefly discussed in section 4.2.

A widely adopted scheme for selecting measurements, also called sensing actions in some contexts (or deliberation steps, in the context of meta-reasoning) is based on value of information (VOI) [9]. Computing value of information is intractable in general, thus both researches and practitioners often use various forms of myopic VOI estimates [9] coupled with greedy search.

Even when not based on solid theoretical guarantees, such estimates lead to practically efficient solutions in many cases.

However, in a selection problem involving real-valued items, the main focus of this paper, coupled with the capability of the system to perform more than one measurement for each item, the myopic VOI estimate can be shown to badly underestimate the value of information. This can lead to inferior measurement sequences, due to the fact that in many cases no measurement is seen to have a VOI estimate greater than its cost, due to the myopic approximation. Our goal is to find a scheme that, while still efficiently computable, can overcome this limitation of myopic VOI.

We propose the framework of semi-myopic VOI, which includes the myopic VOI as the simplest special case,