
## 2.3 Myopic Value Of Information Estimate

Computing value of information of a measurement is intractable, and is thus usually estimated instead under the assumptions of *meta-greediness* and *single-step*. Under these assumptions, the myopic scheme considers only one measurement step, and ignores value of later measurements. A measurement step can consist of a single measurement or of a fixed number thereof with no deliberation between the measurements.

A measurement is beneficial only if it changes which item appears to have the greatest estimated expected utility. For items that are mutually independent (essentially the *subtree independence* assumption of [9]),
a measurement only affects beliefs about the measured item. If the measured item does not seem to be the best now, but can become better than the current best item α when the belief is updated, the benefit in this case is:

$$B_{i}(y)=\operatorname*{max}\left(\int\limits_{-\infty}^{\infty}u(x)p_{i}^{+}(x|y)d x-E(U_{\alpha}),0\right)\quad(4)$$

If the measured item α can become worse than the next-to-best item β, the benefit is:

$$B_{i}(y)=\operatorname*{max}\left(E(U_{\beta})-\int\limits_{-\infty}^{\infty}u(x)p_{i}^{+}(x|y)d x,0\right)\quad(5)$$

where y is the observed outcome, and p
+
i
(x|y) is the posterior belief. For these two cases, the myopic VOI estimate *MV I* of observing the ith item at step j of the algorithm is:

$$M V I_{i}=\int\limits_{-\infty}^{\infty}p_{i}^{-}(x)\int\limits_{-\infty}^{\infty}B_{i}(y)p_{o}(y|x)d y d x-c(j)\quad(6)$$

## 2.4 Myopic Scheme: Shortcomings

The decisions the myopic scheme makes at each step are: which measurement is the most valuable, and whether the most valuable measurement has a positive value. The simplifying assumptions are justified when they lead to decisions sufficiently close to optimal in terms of the performance measure, the net utility.

The first decision controls search "direction". When it is wrong, a non-optimal item is measured, and thus more measurements are done before arriving at a final decision. The net utility decreases due to the higher costs. The second decision determines when the algorithm terminates, and can be erroneously made too late or too early. Made too late, it leads to the same deficiency as above: the measurement cost is too high.

Made too early, it causes early and potentially incorrect item selection, due to wrong beliefs. The net utility decreases because the item's utility is low.

In terms of value of information, the assumptions lead to correct decisions when the value of information is negative for every sequence of steps, or if there exists a measurement that according to the meta-greedy approach has the greatest (positive) VOI estimate, and is the head of an optional measurement plan. These criteria are related to the notion of *non-increasing returns*; the assumptions are based on an implicit hypothesis that the intrinsic value grows more slowly than the cost. When the hypothesis is correct, the assumptions should work well; otherwise, the myopic scheme either gets stuck or goes the wrong way. It is commonly believed that many processes exhibit diminishing returns; the *law of diminishing returns* is considered a universal law in economics [4]. However, this only holds asymptotically: while it is often true that starting with some point in time the returns never grow, until that point they can alternate between increases and decreases. Sigmoid-shaped returns were discovered in marketing [3]. As experimental results show [13], they are not uncommon in sensing and planning. In such cases, an approach that can deal with increasing returns must be used.

## 2.5 Pathological Example

Let us examine a simple example where the myopic estimate behaves poorly:

- S is a set of two items, s1 and s2, where the value of s1 is known exactly, x1 = 1;
- the prior belief about the value of s2 is a normal distribution p2(x) = N(x; 0, 1);
- the observation variance is σo = 5;
- the observation cost is constant, and chosen so that the net value estimate of a two-observation step is zero: c(j) = *MV I*2 2 2 ≈ 0.00144;
- the utility is a step function:

$$u(x)={\left\{\begin{array}{l l}{0}&{{\mathrm{~if~}}x<1}\\ {0.5}&{{\mathrm{~if~}}x=1}\\ {1}&{{\mathrm{~if~}}x>1}\end{array}\right.}$$
