
$$\operatorname*{lim}_{k\to\infty}n\,{\sqrt[k]{\frac{1}{n}}}=n$$

But the blinkered algorithm will always choose the first item with Vb = v1(m) = 1.

## 4 Empirical Evaluation

It is rather difficult to perform informative experiments on a real setting of the selection problem. Therefore, other than one case coming from a parameter selection application, empirical results in this paper are for artificially generated data.

## 4.1 Simulated Runs

The first set of experiments is for independent normally distributed items. For a given number of items, we randomly generate their exact values and initial prior beliefs. Then, for a range of measurement costs, budgets, and observation precisions, we run the search, randomly generating observation outcomes according to the exact values of the items and the measurement model. The performance measure is the regret - the difference between the utility of the best item and the utility of the selected item, taking into account the measurement costs. We examine the result of using the blinkered scheme vs. other semi-myopic schemes.

The first comparison is the difference in regret between the myopic and blinkered schemes, done for 2 items, one of which has a known value (Table 1). A positive values in the cells, indicates an improvement due to the blinkered estimate. Note that the absolute value is bounded by 0.5, the difference in the utility of the exactly known item and the extremal utility.

σo \ C 0.0005 0.0010 0.0015 0.0020

3 0.0147 0.0156 0.0199 0.2648

4 0.0619 0.2324 0.2978 0.2137

5 0.2526 0.2322 0.1729 0.1776

6 0.1975 0.1762 0.1466 0.0000

Table 1: 2 items, 5 measurement budget

σo \ C 0.0005 0.0010 0.0015 0.0020

3 0.0113 -0.00459 -0.0024 0.4352

4 0.0374 0.43435 0.4184 0.3902

5 0.4060 0.40004 0.3534 0.3599 6 0.4082 0.37804 0.3337 0.0000

Table 2: 4 items, 10 measurement budget Averaged over 100 runs of the experiment, the difference is significantly positive for most combinations of the parameters. In the first experiment (Table 1), the average regret of the myopic scheme compared to the blinkered scheme is 0.15 with standard deviation 0.1.

In the second experiment (Table 2), the regret is 0.27 with standard deviation 0.19.

## 4.1.1 Other Semi-Myopic Estimates

In this set of experiments, we compare three semimyopic schemes: blinkered, omni-myopic, and exhaustive. All schemes were run on a set of 5 items with a 10 measurement budget. The results show that while blinkered is significantly better than pure myopic (Table 3), exhaustive is only marginally better than blinkered (Table 4), even though it requires evaluating an exponential number of sets of measurements. Another semi-myopic scheme, omni-myopic, is only marginally better than myopic (Table 5).

σo \ C 0.0005 0.0010 0.0015 0.0020

3.0 -0.1477 0.0946 0.1889 0.2807 4.0 0.0006 0.0382 0.4045 0.4180 5.0 0.2300 0.3954 0.2925 0.3222 6.0 0.0494 0.2374 0.1452 0.2402

Table 3: myopic vs. blinkered

σo \ C 0.0005 0.0010 0.0015 0.0020

3.0 0.0218 0.0307 0.1146 -0.1044 3.0 -0.0502 0.0703 0.0598 0.0022

3.0 0.0940 -0.1508 -0.0865 0.1432

3.0 0.0146 0.1485 -0.0505 0.2068

Table 4: blinkered vs. exhaustive

σo \ C 0.0005 0.0010 0.0015 0.0020

3.0 -0.0781 -0.0167 0.0391 0.0125

4.0 0.0000 0.0974 0.1848 -0.0982

5.0 0.0609 -0.0002 0.0000 0.0000

6.0 0.1272 0.0000 0.0000 0.0000

Table 5: myopic vs. omni-myopic

## 4.1.2 Dependencies Between Items

When the values of the items are linearly dependent, e.g. when: xi = xi−1 + w with w being a random variable distributed as N(0, σ2w), the VOI of series of observations of several items can be greater than the sum of VOI of each observation. We examine the influence of dependencies on the relative quality of the blinkered and omni-myopic schemes.

When there are no dependencies, i.e. σ 2 o σ2w= 0, the blinkered scheme is significantly better. But as σw