# Updating Sets Of Probabilities

Adam J. Grove NEC Research Institute 4 Independence Way Princeton, N J 08540 grove@research.nj .nee. com 

## Abstract

There are several well-known justifications for conditioning as the appropriate method for updating a single probability measure, given an observation. However, there is a significant body of work arguing for sets of probability measures, rather than single measures, as a more realistic model of uncertainty. Conditioning still makes sense in this context-we can simply condition each measure in the set individually, then combine the results-and, indeed, it seems to be the pre� 
ferred updating procedure in the literature. 

But how justified is conditioning in this richer setting? Here we show, by considering an axiomatic account of conditioning given by van Fraassen, that the single-measure and sets-of-measures cases are very different. We show that van Fraassen's axiomatization for the former case is nowhere near sufficient for updating sets of measures. We give a considerably longer (and not as compelling) list of axioms that together force conditioning in this setting, and describe other update methods that are allowed once any of these axioms is dropped. 

## 1 Introduction

A common criticism of the use of probability theory is that it requires the agent to make unrealistically precise uncertainty distinctions. One widely-used approach to dealing with this has been to consider sets of probability measures as a way of modeling uncertainty 
(see, for example, [Breese and Fertig 1991; Gilbo� 
and Schmeidler 1993; Huber 1980; Kyburg 1974; Levr 1980; Smith 1961]). Given that one adopts the setsof-measures model, how should one update these measures in the light of new evidence? There is an "ob-
*This work was supported in part by NSF under grant IRI-96-25901 and by the Air Force Office of Scientific Research under grant F49620-96-l-0323. 

Joseph Y. Halpern* Cornell University Dept. of Computer Science Ithaca, NY 14853 halpern@cs.cornell.edu http:/ /www.cs.cornell.edu/home/halpern vious" approach available, which is to apply standard probabilistic conditioning to each of the measures in the set individually and then combine the results. It is typically taken for granted that this is the appropriate thing to do (see, for example, [Cozman 1997]). But what justifies this approach? 

There have been numerous attempts to justify conditioning as the appropriate way to update single probability measures. The standard approach involves Dutch Book arguments [Kemeny 1955; Shimony 1955; Teller 1973]. However, these arguments have not always been viewed as so convincing; see Bacchus, Kyburg, and Thaler [1990] and Howson and Urbach [1989] 
for a summary of these arguments and some counterarguments against them. In any case, even if we accept the standard justifications for conditioning, there is no a priori reason to believe that they must also apply to the sets-of-measures case. In fact, they may not, and demonstrating this is a major point of this paper. We focus here on a different, yet simple and compelling defense of (ordinary) conditioning, due to van Fraassen 
[van Fraassen 1987; Hughes and van Fraassen 1985]. 

Van Fraassen considers two simple and arguably quite reasonable properties that we might demand of an update process and shows that conditioning is the only mechanism that satisfies these properties. We show that these properties are not sufficient in the setsof-measures case. Indeed, there are numerous other update mechanisms that satisfy them. We also show that, by postulating enough extra properties, we can recover conditioning as the unique solution; however, the properties we seem to need are far less compelling than those required for the original result. 

We begin with an informal description of van Fraassen's result. He wants to examine arbitrary approaches for updating probabilities in the light of new evidence. Thus, he considers a function upd (for up-date) that takes two arguments-a probability measure Pr on a domain W and a subset B � W-and returns a new probability measure upd(Pr, B), which, intuitively, is the result of updating Pr by the evidence B. It certainly seems reasonable to require 