date rule is equivalent to Dempster's Rule of Conditioning. We discuss these results in more detail in Section 3. 

- Walley [1991] has a theory of lower and upper previsions based on gambles and considers an approach to updating previsions called the generalized Bayes rule, which, as the name suggests, generalizes standard conditional probability. Sets of gambles can be associated with (convex) sets of probability measures; Moral and Wilson [1995] 
consider approaches to revising closed sets of gambles given another gamble1 and relate their approaches to the AGM postulates. 
The rest of this paper is organized as follows. In Section 2 we define update functions carefully and give some examples of them. In Section 3, we state our postulates. In Section 4 we outline the proof of our main result, which is that our postulates characterize conditioning. Despite the strength of our postulates, our proof is surprisingly difficult, which is perhaps further evidence that quite strong postulates are necessary to characterize conditioning in the sets-of-measures case. 

We conclude in Section 5. 

## 2 Update Functions

The general framework we work in is a straightforward extension of van Fraassen's. Suppose we have a measure space M = (W, F), that is, a domain W and an algebra F over W.2 Let 6M consist of all probability measures over M. An update function on M is a function Upd: 2 6-M x F �26-M, such that Upd(X, B) = 0 if Pr(B) = 0 for all Pr E X. 3 That is, Upd takes as input a set of probability measures over M and an element ofF, and returns a set of measures over M. 

Intuitively, Upd(X, B) consists of the result of updating the measures in X by the observation B. If X 
is the singleton set {Pr}, we write Upd(Pr,B) rather than Upd({Pr},B). Note that for us, however, unlike for van Fraassen, Upd(Pr, B) is a set of measures (possibly empty), not a single measure. 

Van Fraassen's symmetry requirement (i.e., represen1 Since events can be viewed as a special case of gambles, this is a more general notion of updating than that considered here. 

2 An algebra :F over W is a set of subsets of W that includes W and is closed under complementation and union, so that if A, B E X, then so are A and AU B. In the case that W is infinite, we could also require that :F be a u-algebra, that is, closed under countable union. None of our results would change if we made this requirement. 

3The final condition in this definition is analogous to the conventional restriction that one cannot condition on a measure 0 event. It is well known that the problem of defining a sensible notion of "update" for measure 0 events is a nontrivial one, even in the the conventional (single measure) framework. However, this problem is (largely) 
orthogonal to the topic of this paper. Note that this condition implies that Upd(0, B) = 0. 

tation independence), considers not one update function, but two, acting on different domains, and relates their outputs. Thus, we are interested in families UpdM of update functions, one for each measure space M. We use Upd as a way of denoting the whole family 
{ Up�}.4 As defined, families of update functions can be completely arbitrary. They can act like conditioning in one space and return a fixed probability measure in another. We now give examples of seven families of update functions that are not completely arbitrary, in that they satisfy a number of properties of interest to us, although in some cases their behavior is quite far from conditioning. 

- Upd;;;;nd
(X,B) = {Pr(·IB) : PrE X,Pr(B) > 0}. 

Updcond is the standard update via conditioning. 

More precisely, we condition when possible; we simply discard those probability measures Pr E X 
such that Pr(B) = 0. 
- Upd;;;;nstrain(X,B) = {PrE X: Pr(B) = 1}. 

Updconstrain is just Voorbraak's [1996] notion of constraining, as discussed in the Introduction. 

Note that Upd;;;;nstrain(X, B) = 0 if X contains no probability measures Pr such that Pr(B) = 1. 

- Updj,;rget(X,B) = {PrE 6M: Pr(B) = 1}. 

With Upd o_Tfl.

et> we ignore the information in X altogether. While this may seem to be a completely uninteresting update function, note that it can be viewed as modeling an agent who learns B, but then forgets what he knew before (which we can think of as being encoded by X). It points out the role of "no forgetting" in conditioning, an issue to which we return below. 

- Upd�vial(X, B)= 0. 

We have already seen that, in general, we may have Upd(X, B) = 0 even if X =f. 0. With Updtrivial> we take this one step further and have the output be the empty set independent of X 
and B. While this is clearly a rather uninteresting update function, we must be careful about what requirements to impose to ban it, so we do not ban too much. 

- Upd�sure(X,B) = Upd;;;;nd
(Xc,B) = ({Pr(·IB): 
Pr E xc, Pr(B) =f. 0} ), where xc denotes the topological closure of X, that is, xc consists of all measures Pr such that for all f > 0, there exists a measure Pr' EX such that supAEF I Pr(A)
Pr'(A)I < t:. 

Updclosure shows that update functions can take topological conditions into account. Note that Updcond and Updclosure agree on all finite sets X. 

4Readers concerned about cardinality considerations should think in terms of restricting to domains that have at most a certain cardinality, such as the cardinality of the reals. 