
## C. Qualitative Basic Belief Assignment

1) Qualitative operators on linguistic labels: Recently Smarandache and Dezert [13], [19], [20] have proposed an extension of classical quantitative belief assignments and numerical operators to qualitative beliefs expressed by linguistic labels and qualitative operators in order to be closer to what human experts can easily provide. In order to compute directly with words/linguistic labels and qualitative belief assignments instead of quantitative belief assignments over GΘ, Smarandache and Dezert have defined in [19] a *qualitative basic belief assignment* qm(.) as a mapping function from GΘ into a set of linguistic labels L = {L0**,L, L** ˜n+1} where L˜ = {L1, · · · , Ln} is a finite set of linguistic labels and where n ≥ 2 is an integer. For example, L1 can take the linguistic value "poor", L2 the linguistic value "good", etc. L˜ is endowed with a total order relationship ≺, so that L1 ≺ L2 **≺ · · · ≺** Ln. To work on a true closed linguistic set L under linguistic addition and multiplication operators, Smarandache and Dezert extended naturally L˜ with two extreme values L0 = Lmin and Ln+1 = Lmax, where L0 corresponds to the minimal qualitative value and Ln+1 corresponds to the maximal qualitative value, in such a way that L0 ≺ L1 ≺ L2 **≺ · · · ≺** Ln ≺ Ln+1, where ≺ means inferior to, less (in quality) than, or smaller than, etc. Labels L0, L1, L2, . . . , Ln, Ln+1 are called *linguistically equidistant* if: Li+1 − Li = Li − Li−1 for all i = 1, 2**, . . . , n** where the definition of subtraction of labels is given in the sequel by (14). In the sequel Li ∈ L are assumed linguistically equidistant2labels such that we can make an isomorphism between L = {L0, L1, L2, . . . , Ln, Ln+1} and {0, 1/(n + 1), 2/(n + 1), . . . , n/(n **+ 1)**, 1}, defined as Li = i/(n **+ 1)** for all i = 0, 1, 2, . . . , n, n + 1. Using this isomorphism, and making an analogy to the classical operations of real numbers, we are able to justify and define precisely the following qualitative operators (or q-operators for short):
- q-addition of linguistic labels:

$$L_{i}+L_{j}=\frac{i}{n+1}+\frac{j}{n+1}=\frac{i+j}{n+1}=L_{i+j},\tag{8}$$

we set the restriction that i + j < n + 1; in the case when i + j ≥ n + 1 we restrict Li+j = Ln+1 = Lmax. This is the justification of the qualitative addition we have defined.

- q-multiplication of linguistic labels3:
a) Since Li·Lj =i n+1 ·j n+1 =
(i·j)/(n+1)
n+1 , the best approximation would be L[(i·j)/(n**+1)]**, where [x] means the closest integer to x (with [n + 0.5] = n + 1, ∀n ∈ IN), *i.e.*

* [10] M. C.  

$$L_{i}\cdot L_{j}=L_{[(i\cdot j)/(n+1)]}.$$
$$(9)$$
Li· Lj = L[(i·j)/(n**+1)]**. (9)
For example, if we have L0, L1, L2, L3, L4, L5, corresponding to respectively 0, 0.2, 0.4, 0.6, 0.8, 1, then L2 ·L3 =
L[(2·3)/5] = L[6/5] = L[1.2] = L1; using numbers: 0.4 · 0.6 = 0.24 ≈ 0.2 = L1; also L3 · L3 = L[(3·3)/5] = L[9/5] = L[1.8] = L2; using numbers 0.6 · 0.6 = 0.36 ≈ 0.4 = L2.

b) A simpler approximation of the multiplication, but less accurate (as proposed in [19]) is thus:

$$(10)$$
$$L_{i}\cdot L_{j}=L_{\operatorname*{min}\{i,j\}}.$$
Li· Lj = Lmin{i,j}. (10)
- Scalar multiplication of a linguistic label: