When working with labels, no matter how many operations we have, the best (most accurate) result is obtained if we do only one approximation. That one should be at the end. For example, if we have to compute terms like LiLjLk/(Lp + Lq)
as for Qualitative Proportional Conflict Redistribution (QPCR) rule (see example in section IV), we compute all operations as defined above. Without any approximations (*i.e.* not even calculating the integer part of indexes, neither replacing by n + 1 if the intermediate results is bigger than n + 1), so:

6
$$\frac{L_{1}L_{2}L_{3}L_{4}}{L_{p}+L_{q}}=\frac{L_{(4)(p+q)}}{L_{p+q}}=L_{\frac{(4)(p+q)+(p+q)}{p+q}}\ (o+1)=L_{\frac{(4)(p+q)+(p+q)}{p+q}}=L_{\frac{(4)}{p+q}}\tag{15}$$  and now, when all work is done, we compute the integer part of the index, _i.e._$[\frac{1}{(p+q)(p+q)}]$ or replace it by $n+1$ if the final result 
is bigger than n+ 1. Therefore, the term LiLjLk/(Lp+Lq) will take the linguistic value Ln+1 whenever [ijk
(n**+1)(**p+q)
] > n+ 1.

This method also insures us of a unique result, and it is mathematically closer to the result that would be obtained if working with corresponding numerical masses. Otherwise, if one approximates either at the beginning or end of each operation or in the middle of calculations, the inaccuracy propagates (becomes bigger) and we obtain different results, depending on the places where the approximations were done. If we need to round the labels' indexes to integer indexes, for a better accuracy of the result, this rounding must be done at the very end. If we work with fractional/decimal indexes (therefore no approximations),
then we can normally apply the qualitative operators one by one in the order they are needed; in this way the quasi-normalization is always kept.

2) Quasi-normalization of qm(.): There is no known way to define a normalized qm(.), but a qualitative quasi-normalization
[19], [24] is nevertheless possible when considering equidistant linguistic labels because in such case, qm(Xi) = Li, is equivalent to a quantitative mass m(Xi) = i/(n **+ 1)** which is normalized if:
but this one is equivalent to:

$$\sum_{X\in G^{\Theta}}m(X)=\sum_{k}i_{k}/(n+1)=1,$$
$$\sum_{X\in G^{\Theta}}qm(X)=\sum_{k}L_{i_{k}}=L_{n+1}.$$

In this case, we have a *qualitative normalization*, similar to the (classical) numerical normalization. However, if the previous labels L0, L1, L2, **. . .**, Ln, Ln+1 from the set L are not equidistant, the interval [0, 1] cannot be split into equal parts according to the distribution of the labels. Then it makes sense to consider a qualitative quasi-normalization, *i.e.* an approximation of the (classical) numerical normalization for the qualitative masses in the same way:

$$\sum_{X\in G^{\Theta}}q m(X)=L_{n+1}.$$

In general, if we don't know if the labels are equidistant or not, we say that a qualitative mass is quasi-normalized when the above summation holds. In the sequel, for simplicity, one assumes to work with quasi-normalized qualitative basic belief assignments.

From these very simple qualitative operators, it is possible to extend directly all the quantitative combination rules to their qualitative counterparts as we will show in the sequel.