Typically, the within-instance dependencies are stronger than the dependencies across instances. We can exploit this to reduce the number of property values as follows: First, **find the MAP of each instance independently.** Only those property values that are fired in the MAP labeling of at least one of the instances are considered in the range. In the application we study in Section 7.2, this reduced the size of the range of properties drastically.

A second trick can be used when properties are associated with labels that tend not to repeat in the MRF,
e.g. Title for the citation extraction task. In that case, the value ⊥ **can be ignored. And, we can relax the**
consistency checks on properties p′**that are being absorbed so that they can be absorbed locally at each clique**
as follows. First, normalize incoming messages from p′ as mp′→i(v) − mp′→i(∅**). Next, absorb the normalized**
message in the clique potential φc(yc) of all cliques where p′(x, yc, c) = v**. Finally, compute the outgoing message**
by only keeping state over the values of the outgoing property. When the MAP does not contain any repeat firings of a property, this method returns the exact answer.

A third option is to depend on generic search optimization tricks like beam search and rank aggregation. In beam search instead of maintaining messages for each possible combination of property values, we maintain only top-k most promising combinations in each message passing step.

## 5.2 Message From A Clique To An Instance

The message mp→i(v**) is computed as:**

$$m_{p\to i}(v)=\max_{(v_{i},v_{i}=v_{p}):}\sum_{\begin{subarray}{c}j\neq i\\ \mathbf{x}_{j}\in\mathcal{D}_{p}\end{subarray}}m_{j\to p}(v_{j})+\mathrm{C}p(\{v_{j}\}_{\mathbf{x}_{j}\in\mathcal{D}_{p}})\tag{22}$$

Message mp→i(v**) requires maximizing the objective in Equation 22, which can be re-written as**

$$-m_{i\to p}(v)+\operatorname*{max}_{(v_{i},\dots,v_{n})\atop v_{i}=v}\sum_{j:{\bf x}_{j}\in{\mathcal{D}}_{p}}m_{j\to p}(v_{j})+\mathrm{C}p(\{v_{j}\}_{{\bf x}_{j}\in{\mathcal{D}}_{p}})$$

The maximization subtask can be cast in terms of the general *clique inference problem* **defined as:**
Definition 5.1. Given a clique over n *vertices, with a symmetric clique potential C*(v1**, . . . , v**n), and vertex potentials ψjvjfor all j ≤ n and values vj *. Compute the value assignment with the highest potential:*

$\downarrow$ *clique inference problem* defined as:. 
max v1,...,vn Xn j=1 ψjvj + C(v1, . . . , vn) (23)
$$(23)$$
In our case, ψjv , mj→p(v) and C , Cp. To compute mp→i(v**), we can solve the clique inference problem**
with the restriction vi = v.

We are interested in the cases when the clique potential is Potts or majority**, which were defined in Section 4.**
These are most popular potentials for real-life collective inference tasks.

In [10], a 13 15 -approximate clique inference algorithm, called α-pass was presented for CPotts**, along with**
an expensive polynomial-time exact algorithm for CMaj. α**-pass can also be applied to arbitrary symmetric**
potentials and is exact for binary valued properties. The time complexity of α-pass is O(|R′p|n log n**), as compared** to (|R′p| 2n 2**) for ordinary belief propagation.**
We next show that although α**-pass is also applicable for** majority **potentials, it lacks desirable theoretical**
guarantees. We then present a new approximate inference algorithm for CMaj **based on Lagrangian Relaxation**
which is much faster than the exact algorithm yet produces almost-optimal scores in practice.

## 6 Algorithms For Clique Inference

In this section we explore various exact and approximate schemes for maximizing the clique inference objective in Definition 5.1 under a variety of symmetric potential functions. Of **particular interest are the Potts and**
majority **potentials, but some of the algorithms are more general and apply to families of potentials.**
These clique algorithms are called as subroutines while calculating the messages from property cliques to instances, in accordance with Equation 22. Throughout this section, we assume that the clique corresponds to a fixed property p with range R′p. R **will be short-hand for** |R′p|.