
## 6.3 Clique Inference For Majority **Potentials**

Recall that majority potentials are of the form C = fa(n), a = argmaxv nv. We consider linear majority potentials where fa(n) = Pv wavnv. The matrix W = {wvv′} **is not necessarily diagonally dominant or**
symmetric.

We show that exact MAP for linear majority potentials can be found in **polynomial time. We also present**
a modification to the α**-pass algorithm to serve as an efficient heuristic, but without approximation guarantees.** Then we present a Lagrangian relaxation based approximation, whose runtime in practice is similar to α**-pass,** but provides much better solutions.

## 6.3.1 Modified Α**-Pass Algorithm**

In the case of linear majority potentials, we can incorporate the clique term in the vertex potential, and this leads to the following modifications to the α-pass algorithm: (a) Sort the list for α **according to the modified**
metric ψiα + wαα − maxv6=α(ψiv + wαv), and (b) While sweeping the list for α**, discard all candidate solutions**
whose majority value is not α.

However even after these modifications, α**-pass does not provide the same approximate guarantee as for**
homogeneous Potts potentials, as we prove next. We denote a matrix W **as diagonally dominant iff each of its** diagonal entries are the largest in their corresponding rows.

Theorem 6.9. The modified α*-pass algorithm cannot have an approximation ratio better than* 12 on linear majority potentials with unconstrained W. Proof. Consider the degenerate example where all vertex potentials are zero. Let β and γ **be two fixed values**
and let the matrix W be defined as follows: wβγ = M + ǫ, wβv = M ∀v 6= β, γ **and all the other entries in** W
are zero.

In modified α-pass, when α 6= β, the assignment returned will have a zero score. When α = β**, all vertices**
will prefer the value γ, so α-pass will have to assign exactly n/2 vertices as β **to make it the majority value, thus**
returning a score of (M+ǫ)n 2. However, consider the assignment which assigns n/R **vertices to each value, with a**
score of (R − 1)Mn/R**. Hence the approximation ratio cannot be better than** 12
.

Theorem 6.10. The modified α*-pass algorithm cannot provide an approximation bound better than* 23 for linear majority potentials even when W is diagonally dominant and each of its rows have equal sums.

Proof. The proof is by counter example which is constructed as follows. Let the set of values R′p **be divided** into two subsets, A and B with k and n − k values respectively, where k < n/2. Let β ∈ B **be a fixed value. We**
define W as:

$$w_{v v^{\prime}}={\left\{\begin{array}{l l}{n-k}&{v,v^{\prime}\in A}\\ {}&{}\\ {k+1}&{v\in A,v^{\prime}=\beta}\\ {}&{}\\ {k+1}&{v,v^{\prime}\in B}\\ {}&{}\\ {0}&{o t h e r w i s e}\end{array}\right.}$$

Thus W is diagonally dominant with all rows summing to (n − k)(k **+ 1).**
The vertex potentials ψ are defined as follows. Divide the vertices into k chunks of size n/k **each. For the**
v th value in A**, each vertex in the** v th chunk has a vertex potential of 2(n − k). Further, ψiβ = 2(n − k) ∀i**. The**
remaining vertex potentials are zero.

The optimal solution is obtained by assigning the v th value in A **to the** v th **chunk, with a total score of**
n k
.2(n − k).k + (n − k).

n k
.k = 3n(n − k).

In α-pass, consider the pass for α ∈ A. Each vertex i prefers β because ψiβ + wαβ = 3(n − k**) is the best**
across all values. Thus, the best α-pass generated assignment with majority value α **is one where we assign** n/2 vertices α, including the n/k vertices that correspond to the chunk of α**. The vertex and clique potentials of this**
assignment are n k
.2(n − k) + n 2
.2(n − k**) and** n 2
(n − k) + n 2
(n − k), giving a total score of 2n(n − k) + 2n(n−k)
k.

This gives an approximation ratio of 23
(1 + 1k
).

Now consider the pass when α ∈ B. Each vertex i again prefers β because ψiβ + wαβ = 2n − k **+ 1 is the best**
across all values. If α = β, the best α-pass assignment is one where all vertices are assigned β**, giving a total**