cost of n(2n − k + 1). If α 6= β, then to make α the majority value, α**-pass can only output an assignment with**
score less than n(2n − k **+ 1). In this case, the approximation ratio is no better than** 2n−k+1 3(n−k)
.

Setting k =
√n and n → ∞**, we get the desired result.**
However, in practice where the W matrix is typically sparse, our experiments in Section 7.1 show that α**-pass**
performs well and is significantly more efficient than the exact algorithm described next.

## 6.3.2 Exact Algorithm

Since majority potentials are linear, we can pose the optimization problem in terms of **Integer Programs (IPs).**
Assume that we know the majority value α**. Then, the optimization problem corresponds to the IP:**

$$\max_{\mathbf{z}}\sum_{i,v}(\psi_{iv}+w_{av})z_{iv}$$ $$\forall v:\ \sum_{i}z_{iv}\leq\sum_{i}z_{i\alpha},$$ $$\forall i:\ \sum_{v}z_{iv}=1,\ z_{iv}\in\{0,1\}\tag{28}$$  $\sum_{v}z_{iv}$ and $\sum_{v}z_{iv}$ are the $v$-th and $w$-th respectively, respectively.  
We can solve R **such IPs by guessing various values as the majority value, and reporting the best overall**
assignment as the output. However, Equation 28 cannot be relaxed to a linear program. This can be easily shown by proving that the constraint matrix is not totally unimodular. Alternatively, here is a counter example:
Consider a 3-node, 3-value graphical model with a zero W **matrix. Let the vertex potential vectors be** ψ0 = (1, 4, 0), ψ1 = (4, 0, 4), ψ2 = (3, 4, 0). While solving for α = 0, the best IP assignment is 1, 0, **0 with a score of**
11. However the LP relaxation has the solution z = (0, 1, 0; 1, 0, 0; 1/2, 1/2, **0) with a score of 11**.5.

This issue can be resolved by making the constraint matrix totally unimodular as follows. Guess the majority value α, the count k = nα**, and solve the following IP:**

$$\operatorname*{max}_{\mathbf{z}}\sum_{i,v}(\psi_{i v}+w_{\alpha v})z_{i v}$$ $$\forall v\neq\alpha:\ \sum_{i}z_{i v}\leq k,$$ $$\sum_{i}z_{i\alpha}=k,$$ $$\forall i:\ \sum_{v}z_{i v}=1,\ z_{i v}\in\{0,1\}$$
$$\left(\text{29}\right)$$. 
ziv = 1, ziv ∈ {0, 1} **(29)**
This IP solves the degree constrained bipartite matching problem, which can be solved exactly in polynomial time. Indeed, it can be shown that the LP relaxation of this IP has an **integral solution.**
Theorem 6.11. The integer program in Equation 29 has a tight LP relaxation.

Proof. Denote the constraint matrix of program 29 by A(m+n)×mn, and let A1 and A2 **denote its first** m − 1 and last n + 1 rows respectively. The n + 1 equality constraints can be converted into '≤**' constraints by adding**
negative slack variables. For example, si +Pv ziv ≤ **1 and** sα +Pi ziα ≤ k**. The variables are now (**z, s)
T**, and**

the extra constraints are $\mathbf{s}\leq\mathbf{0}$. The new constraint matrix of this system (which has only inequality constraints) is given by $B=\left[\begin{array}{cc}A_{1}&0\\ A_{2}&I\\ 0&I\end{array}\right]$. The tightness of the LP relaxation follows if $B$ is totally unimodular. For that, it suffices to prove that $A=\left[\begin{array}{c}A_{1}\\ A_{2}\end{array}\right]$ is totally unimodular. This is so because then $\left[\begin{array}{cc}A_{1}&0\\ A_{2}&I\end{array}\right]$ would be totally unimodular, and by extension of the same argument, so would be $B$. The total unimodularity of $A$ is proven as follows.  