Theorem 6.12. z∗ and γ∗ are optimum solutions to Equations 28 and 31 respectively if *they satisfy the conditions:*

$$\forall v:\qquad\sum_{i}z_{iv}^{*}\leq\sum_{i}z_{i\alpha}^{*}$$ $$\forall v:\qquad|\gamma_{y}^{*}(\sum_{i}z_{iv}^{*}-\sum_{i}z_{i\alpha}^{*})|=0$$
 $\left(34\right)$  $\left(35\right)$  $\left(35\right)$
Theorem 6.12 holds only for fractional z∗**. To see how, consider an example with 3 vertices and 2 values. Let**
ψi0 + wα0 > ψi1 + wα1 for all i and α. During Lagrangian relaxation with α = 1, initially γ = 0 **will cause all**
vertices to be assigned value 0, violating Equation 34. Since the count difference Pi zi0 −Pi zi1 **∈ {±**1, ±2, ±3},
any non-zero γ0 will violate Equation 35. Subsequent reduction of γ0 **to zero will again cause the original violation**
of Equation 34. Consequently, one of Equations 34 and 35 will never **be satisfied and the algorithm will oscillate.**
To tackle this, we relax Equation 35 to |γv(Pi z∗
iv −Pi z∗
iα)| ≤ ǫ, where ǫ **is a small fraction of an upper**
bound on γv**, whose computation is illustrated later. This helps in reporting assignments that respect the**
majority constraint in Equation 34 and are close to the optimal.

The outline of the algorithm is described in Figure 2. We now discuss a few possible approaches to select a new γ **at every step.**

## Subgradient Optimization

This approach can be used to change all components of γ **in a single step. Subgradient optimization generates**
a sequence of direction vectors {d 1, d 2, . . .} and positive step sizes {η1, η2, . . .}**. At the** k th step, the γ **vector is**
changed as:
γv ← max(0, γv + ηkd k) **(36)**
In its simplest form, the direction d k**is the violation vector (**Pi ziv −Pi ziα)v=1...R. Thus, if a value v **has a**
count greater than α, then γv will be increased to take some vertices away from v**. In practice though,** d kis usually a convex combination of the violation vector and the previous **direction** d k−1**. This helps in avoiding**
oscillations of the kind where γ k+2 **is very close to** γ k**, while simultaneously moving closer to the optimum.**
The subgradient optimization framework allows various ways to choose the step sizes. For example, if we choose to set the direction using only the violation vector, then a sequence {η1, η2, . . .} **of step sizes satisfying**
(i) limk→∞ ηk **= 0 and (ii)** P∞
k=0 ηk = ∞ **will ensure asymptotic convergence [11]. These are not the only set** of sufficient conditions that guarantee convergence. Practical implementations often compute ηk **using the current**
value of L(γ**), current violations, and a few user defined parameters.**
However, during experimentation the degrees of freedom in choosing the step sizes posed a big problem for us. Since a single step size is shared across all components of γ, a large step size moved everything to α**, while a** small step size considerably slowed down convergence. Data independent approaches to choosing step sizes also failed to converge in a reasonable number of iterations. In general, **subgradient optimization is known to require**
very careful tweaking of the step sizes across iterations in order **to achieve meaningful convergence speeds [11].**
For this reason, we looked at alternate approaches to change γ.

## Golden Search Based Coordinate Descent

If all components of γ except one (say γv), are kept fixed, then L(γ) is a quasi-convex function of γv**. Thus, it**
has a unique global minima, which can be found using golden search, which is an efficient line search method. We choose the value v**, whose corresponding violation is the highest in magnitude.**
Golden search requires lower and upper bounds on γv and evaluates L(γ) at various γ**'s inside that interval.**
As before, L(γ**) can be easily obtained by a computing an assignment which is vertex-optimal wrt the** ψ α's.

We use the trivial lower bound of zero, and estimate a good upper bound from the current solution state. If currently Pi ziv ≤Pu zuα, then γv **(which is a penalty parameter) can be decreased, and therefore the current**
value of γv can serve as an upper bound. On the other hand, if we start increasing γv**, then one by one, the** vertices currently assigned v will switch to their next best values, and by a particular increased value of γv**, all** vertices assigned v would have flipped. There is no need to increase γv **beyond this point, so we use this value** of γv **as our upper bound, which can thus be summarized as :**

$$U B(v)=\operatorname*{max}_{i:z_{i v}=1}\delta_{i v}$$
