
## Adaptation. We Illustrate This Via An Example.

Example: **Consider extracting bibliographic information from an author's publications homepage using a model**
trained on a different set of authors. Typically, within each home (a domain) we expect consistency in the style of individual publication records. For example, we expect that labelings of individual bibliographic records
(approximately) use the same ordering of labels (say T itle → Author∗ → V enue**), regardless of what that**
ordering is. Another property whose conformance might be desirable is - "the HTML tag containing the Title of the publication". Different bibliographic records on the same page **will most probably format the title using** the same HTML tag. Thus, we can encode this associativity by biasing **the labelings to be conformant wrt this** property. For both these properties, we only demand that the labelings agree on the property value, without caring for what the value actually is (which varies from domain to domain). This allows us to use the same property on different domains, with varying formatting and authoring styles.

Now assume that we have an array of such conformance-promoting properties, and a sequential chain model trained on a set of labeled domains. We show that an effective way of adapting the trained model to a new domain is by labeling the MRFs in the new domain collectively while encouraging the **individual labelings to agree on** our set of properties. This is an inference-only approach, unlike many existing solutions for domain adaptation which require expensive model re-training [1, 2, 17]. As we will see in Section 7.2, using this properties-based framework provides significant gains on a bibliographic information extraction task.

To summarize, our collective inference framework consists of two new components attached to any collection of MRFs:
- **Properties: defined over the labelings of individual MRFs,** - **Potentials: defined on the values of properties of all MRFs such that the potential value favors skewness**
in the frequencies of property values.

We describe our framework in detail in Section 4. The collective inference task in our framework is to choose a labeling of the individual MRFs so as to maximize the sum of the scores of each MRF and the potentials of each property. This inference task is more complicated than independently labeling each MRF, which are typically simple tractable models like sequences.

We address the computational challenge by defining special forms of decomposable properties and symmetric potentials that allow efficient inference without sacrificing usability. We exploit this special structure to design efficient MAP inference algorithms. Instead of ordinary belief propagation on the joint graphical model, we define a cluster graph with two kinds of clusters - corresponding to **tractable MRFs, and cliques with symmetric** potential functions. Two important aspects of this algorithm are as follows. First, we use combinatorial methods to compute cluster-specific messages. In Section 6 we present exact and approximate clique inference algorithms for a variety of symmetric potential functions. These algorithms are used to compute max-marginal messages from a clique to its neighboring clusters. Second, we exploit the form **of our properties to define new intermediate** message variables, and provide exact and approximate algorithms for computing these special message values in Section 5. In contrast, a na¨ıve application of graphical model inference could lead to an entire MRF instance being a separator.

In Section 7 our experiments on real tasks show that this form of message passing is faster and more accurate than existing inference methods that do not exploit the form of the **potentials.**
Finally in Section 8, we discuss some future directions for collective inference and outline some important problems in the area.

## Contributions

Our first key contribution is a framework that encourages associativity between properties of labelings of isolated MRFs. We show that the framework support a large class of *decomposable* **properties. Our properties are** functions of a data-instance and its labeling, in contrast to the existing associative setups which model only very specific properties of only the instances. We give an approximate inference procedure based on message passing on the cluster graph, for computing the MAP labeling in our framework. Our procedure maintains tractability by computing property-aware messages and invoking special combinatorial algorithms at the cliques.

The second key contribution is a family of algorithms for various kinds **of symmetric clique potential functions.**
We give an O(mn log n) MAP algorithm for cliques with arbitrary symmetric potentials, where m **is the number**