
| Name     | Form                                                      | Remarks                         |
|----------|-----------------------------------------------------------|---------------------------------|
| max      | maxv fv(nv)                                               | fv is a non-decreasing function |
| sum      | P v                                                       | 2 v                             |
| fv(nv)   | fv non-decreasing. Includes the Potts potential = λ P v n |                                 |
| majority | fa(n), where a = argmaxvnv                                | fa is typically linear          |

Table 2: Various kinds of symmetric clique potentials considered in this paper. n = (n1, . . . , n|V |**) denotes the**
counts of various values among the clique vertices. are not used directly in real-life tasks, they are relatively easier potentials to tackle and provide key insights to deal with the more complex sum potentials. As we will see, the α**-pass algorithm that we derive for this potential**
can be easily ported to other more complex potentials. For the case **of Potts potentials, we will prove that the**
α**-pass algorithm provides a** 13 15 **-approximation.**
3.2 sum **clique potentials**
sum **clique potentials are of the form:**

$$\mathrm{C}(n_{1},\ldots,n_{|V|})=\sum_{v}f_{v}(n_{v})$$
$$\left({\mathrm{3}}\right)$$
v
fv(nv) (3)
These form of potentials includes the special case when the well-known Potts model is applied homogeneously on all edges of a clique. Let λ **be the Potts potential of assigning two nodes of an edge the same value. The**
summation of these potentials over a clique is equivalent (up to a constant) to the clique potential:

$$\mathrm{C}^{\mathrm{Potts}}=\mathrm{C}(n_{1},\ldots,n_{|V|})=\lambda\sum n_{v}^{2}$$
v
v(4)
The Potts model with negative λ **corresponds to the dis-associative case when edges prefer the two end points**
to take different values. The more interesting case is when λ **is positive. For this case, we will borrow the**
α**-pass algorithm for** max **potentials and show that it gives a** 13 15 **-approximation.**

## 3.3 Majority **Potentials**

majority potentials have been used for a variety of tasks such as link-based **classification of web-pages [16]**
and named-entity extraction [15]. A majority potential over a clique C is parameterized by a |V | × |V | **matrix** W = {wvv′}. The role of W **is to capture the co-existence of different value pairs in the same clique.**
Co-existence allows us to downplay 'strict associativity' viz. giving all **vertices of a clique the same value. The**
justification for co-existence is as follows. Consider the conventional collective inference model for named-entity recognition (Figure 1(d)) where a value corresponds to a label. Suppose the word 'America' occurs in a corpus multiple times. Then all occurrences of 'America' will be joined with an associative clique. However, some occurrences of America correspond to Location, while others might correspond to an Organization, say Bank of America. Thus we require most but not all vertices in the America clique to be labeled similarly. This motivates the need for a clique potential with scope for co-existence.

Coming back to W, a highly positive wvv′ would suggest that the values v and v′**should be allowed to co-exist**
in a clique, when v is the majority value in the clique. We allow wvv′ **to be negative to model mutual-exclusion**
amongst value pairs. Our algorithms work for unrestricted W**, although in practice the training procedure that** learns W **might add some constraints.**
We know define majority **potentials as:**
C(n1, . . . , n|V |) = fa(n), a = argmaxv nv (5)
We consider linear majority potentials where fa(n) = Pv wavnv. The matrix W = {wvv′} **need not be diagonally**
dominant or even symmetric. Unlike Potts potential, majority **potential cannot be represented using edge**
potentials.