

![0_image_0.png](0_image_0.png)

Figure 2: Cluster graph for a toy example with three chain-shaped MRF instances and two properties. The TokenLabel property has thin separators, while NextLabel **has separators that consist of the entire instance.**
Both the properties have associative potentials defined on their cliques (shown as blue circles).

## 5 Map Estimation In The Generalized Collective Inference Framework

The natural choice for approximating the NP-hard objective in Equation 6 is ordinary pairwise belief propagation on the joint model. This approach does not work due to many reasons. First, some symmetric potentials like the majority **potential cannot be decomposed along the edges. Second, property-aware messages cannot be**
computed for arbitrary message passing schedules. Third, cluster-membership information of vertices, which is very vital, is not exploited at all.

Other approaches like the stacking based approach of [15] are specific to particular symmetric potentials and do not exploit the full set of messages to compute a more accurate **MAP.**
Hence we adopt message passing on the cluster graph of the model **as our approach, akin to the one proposed**
by [8]. We create a top-level cluster graph model where the clusters correspond to the N **instances and** |P| property cliques. The cluster node of each instance is internally another nested MRF. The cluster for a property p is a clique whose vertices correspond to instances in Dp**. Figure 2 illustrates an example with two properties**
and three data instances.

For complex properties like the NextLabel **property of Section 4.1, the separator between a MRF cluster**
and a property cluster is the entire instance. This is a major departure from known collective models such as the one in Figure 1(e). Known collective models use highly simple properties, e.g. TokenLabel **in Figure 1(e), which**
lead to single vertex separators because the property clique is incident on instances only through a single token, which is known in advance. In the case of complex properties like NextLabel, not only is the property clique incidence information missing, but the clique's incidence is dependent on the property of the entire labeling and not just a single token's label. This causes the entire instance to be a **separator between the property cluster**
and the instance MRF cluster. Therefore, na¨ıve message passing **schemes whose runtime is exponential in the** separator size are inapplicable here. However we exploit the decomposability of properties to simplify message updates.

The setup of message passing on the cluster graph allows us to exploit potential-specific algorithms at the cliques, and at the same time work with any arbitrary clique potential. **It also allows intuitive computation of** property-aware messages.

Let mi→p and mp→i denote message vectors from instance i to an incident property clique p **and vice-versa.**
Let v ∈ R′p denote a property value. Next we discuss how these messages are **computed.**

## 5.1 Message From An Instance To A Clique

The message mi→p(v**) is given by:**

$$m_{i\to p}(v)=\max_{\mathbf{y}:p(\mathbf{x}_{i},\mathbf{y})=v}\left(\phi(\mathbf{x}_{i},\mathbf{y})+\sum_{\begin{subarray}{c}\mathbf{y}^{\prime}\neq\mathbf{y}\\ \mathbf{x}_{i}\in\mathcal{D}_{p^{\prime}}\end{subarray}}m_{p^{\prime}\to i}(p^{\prime}(\mathbf{x}_{i},\mathbf{y}))\right)\tag{14}$$

To compute mi→p(v), we need to absorb the incoming messages from other incident properties p′ 6= p**, and do**
the maximization. When a property p′is applicable to only a single fixed clique c **of the instance, we can easily**