# The Soft Cumulative Constraint

Thierry Petit Emmanuel Poder Thierry.Petit@emn.fr Emmanuel.Poder@laposte.net Research report TR09/06/info, Ecole des Mines de Nantes, LINA UMR CNRS 6241. ´

## Abstract

This research report presents an extension of **Cumulative** of Choco constraint solver, which is useful to encode over-constrained cumulative problems. This new global constraint uses sweep and task interval violation-based algorithms.

## 1 Introduction

The Cumulative global constraint provides a pruning algorithm which takes account **of all**
activities at the same time, which has been proved to be much more efficient than CP approaches considering a conjunction of more primitive constraints. This representation as a global constraint has been widely studied in the literature and integrated into many constraint systems [1, 2, 3, 4, 5].

Definition 1 Let A = {a1**, . . . , a**n} denote a set of n *non-preemptive activities. For each* a ∈ A,
- **start**[a] *is the variable representing its starting point in time.* - dur[a] *is the variable representing its duration.*
- end[a] ∈ end *is the variable representing its ending point in time.*
- res[a] is the variable representing the discrete amount of resource consumed by a*, also* denoted the height of a.

Definition 2 *Consider one resource with a limit of capacity* max **capa** *and a set* A of n activities. At each point in time t, the cumulated height ht *of the set of activities overlapping* t is ht =Pa∈A,start[a]≤t<end[a] min(D(res[a])).

The Cumulative *global constraint [1] enforces that:*
- *C1: For each activity* a ∈ A, start[a] + dur[a] = end[a].

- *C2: At each point in time* t, ht ≤ max **capa**.

In this research report, we deal with cumulative over-constrained problems that may require to be relaxed w.r.t. the resource capacity at some points in time, to obtain solutions. This motivates the definition of a new global constraint, dedicated to over-constrained instances of problems.