
## 2 Cumulative Constraint With Over-Loads

This section presents the SoftCumulativeSum **constraint, useful to express our case-study**
and deal with significant instances. D(x) = {min(D(x)), . . . , max(D(x))} **denotes the domain of variable** x.

## 2.1 Pruning Independent From Relaxation

The SoftCumulativeSum **constraint that will be presented in section 2.2 implicitly defines a**
Cumulative constraint with a capacity equal to max capa. To prune variables in start**, several existing algorithms for** Cumulative **can be used. We recall the two filtering techniques**
currently implemented in the Cumulative **of Choco solver [6], which we extend to handle**
violations in section 2.2.

## 2.1.1 Sweep Algorithm [4]

The goal is to reduce domains of start **variables according to the cumulated profile, which is**
built from compulsory parts of activities, in order not to exceed max capa**. This is done in** Choco using a sweep algorithm [4]. The *Compulsory Part* **[7] of an activity is the minimum** resource that will be consumed by this activity, whatever the final **value of its start. It is** equal to the intersection of the two particular schedules that are **the activity scheduled at** its latest start and the activity scheduled at its earliest start. As domains of variables get more and more restricted, the compulsory part increases, until it **becomes the fixed activity.** Definition 3 The **Compulsory Part** CP(a) of an activity a *is not empty if and only* if max(D(start[a])) < min(D(end[a]))*. If so, its height is equal to* min(D(res[a])) on [max(D(start[a])), min(D(end[a**]))[** *and null elsewhere.*

![0_image_0.png](0_image_0.png)

Figure 1: Compulsory parts.

Example 1 Let a *be an activity such that* **start**[a] ∈ [1, 4], with a duration fixed to 5*, and* b be an activity such that **start**[b] ∈ [1, 6], with a duration fixed to 3*. As depicted by Figure 1,* activity a has a non empty compulsory part, while activity b *has an empty compulsory part.*
Definition 4 The Cumulated Profile **CumP** is the minimum cumulated resource consumption, over time, of all the activities. For a given t*, the height of* **CumP** at time t *is equal* to X
a∈A/t∈[max(D(start[a])),min(D(end[a**]))[**
D(min(res[a]))
That is, the sum of the contributions of all compulsory parts *that overlap t.*